/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/ChestOcclusiveDressingWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEChestOcclusiveDressing.h"
#include "cdm/properties/SEScalar0To1.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QChestOcclusiveDressingWidget::Controls // based off of chronic anemia widget
{
public:
  Controls() {}
  SEChestOcclusiveDressing Action;
  QLabeledComboBox*        Side;
  QLabeledComboBox*        State;
};

QChestOcclusiveDressingWidget::QChestOcclusiveDressingWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  std::vector<QString> sideOptions = {"Left", "Right"};
  std::vector<QString> stateOptions = { "On", "Off" };
  m_Controls->Side = new QLabeledComboBox(this, "Side", sideOptions);
  m_Controls->State = new QLabeledComboBox(this, "State", stateOptions);
  Properties()->layout()->addWidget(m_Controls->Side);
  Properties()->layout()->addWidget(m_Controls->State);
  Reset();
}

QChestOcclusiveDressingWidget::~QChestOcclusiveDressingWidget()
{
  delete m_Controls;
}

void QChestOcclusiveDressingWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

void QChestOcclusiveDressingWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Side->SetEnabled(b);
  m_Controls->State->SetEnabled(b);
}

void QChestOcclusiveDressingWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  (m_Controls->Side->GetIndex() == 0) ?
    m_Controls->Action.SetSide(eSide::Left) :
    m_Controls->Action.SetSide(eSide::Right);
  (m_Controls->State->GetIndex() == 0) ?
    m_Controls->Action.SetState(eSwitch::On) :
    m_Controls->Action.SetState(eSwitch::Off);
}

void QChestOcclusiveDressingWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QChestOcclusiveDressingWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QChestOcclusiveDressingWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QChestOcclusiveDressingWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}