/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/ChestCompressionForceScaleWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEChestCompressionForceScale.h"
#include "cdm/properties/SEScalar0To1.h"
#include "cdm/properties/SEScalarTime.h"

class QChestCompressionForceScaleWidget::Controls
{
public:
  Controls() {}
  SEChestCompressionForceScale Action;
  QScalarWidget* ForceScale;
  QScalarQuantityWidget<TimeUnit>* ForcePeriod;
};

QChestCompressionForceScaleWidget::QChestCompressionForceScaleWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->ForceScale = new QScalarWidget("ForceScale", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->ForcePeriod = new QScalarQuantityWidget<TimeUnit>("ForcePeriod", 0, 10, .25, TimeUnit::s, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->ForceScale);
  Properties()->layout()->addWidget(m_Controls->ForcePeriod);
  
  Reset();
}

QChestCompressionForceScaleWidget::~QChestCompressionForceScaleWidget()
{
  delete m_Controls;
}

void QChestCompressionForceScaleWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->ForceScale->reset();
  m_Controls->ForcePeriod->reset();

}

void QChestCompressionForceScaleWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->ForceScale->enableInput(b);
  m_Controls->ForcePeriod->enableInput(b);
  m_Controls->ForcePeriod->setEnabled(b);
}

void QChestCompressionForceScaleWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->ForceScale->getValue(m_Controls->Action.GetForceScale());
  m_Controls->ForcePeriod->getValue(m_Controls->Action.GetForcePeriod());
}

void QChestCompressionForceScaleWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QChestCompressionForceScaleWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QChestCompressionForceScaleWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QChestCompressionForceScaleWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}