/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/CardiacArrestWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SECardiacArrest.h"
#include "cdm/properties/SEScalar0To1.h"
#include <QString>
#include <vector>
#include "controls/LabeledComboBox.h"

class QCardiacArrestWidget::Controls
{
public:
  Controls() {}
  SECardiacArrest Action;
  QLabeledComboBox* State;
};

QCardiacArrestWidget::QCardiacArrestWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  std::vector<QString> stateOptions = { "On", "Off" };
  m_Controls->State = new QLabeledComboBox(this, "State", stateOptions);
  Properties()->layout()->addWidget(m_Controls->State);
  Reset();
}

QCardiacArrestWidget::~QCardiacArrestWidget()
{
  delete m_Controls;
}

void QCardiacArrestWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
}

void QCardiacArrestWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->State->SetEnabled(b);
}

void QCardiacArrestWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  (m_Controls->State->GetIndex() == 0) ?
    m_Controls->Action.SetState(eSwitch::On) :
    m_Controls->Action.SetState(eSwitch::Off);
}

void QCardiacArrestWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QCardiacArrestWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QCardiacArrestWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QCardiacArrestWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}