/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/AirwayObstructionWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEAirwayObstruction.h"
#include "cdm/properties/SEScalar0To1.h"

class QAirwayObstructionWidget::Controls
{
public:
  Controls() {}
  SEAirwayObstruction Action;
  QScalarWidget* Severity;
};

QAirwayObstructionWidget::QAirwayObstructionWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  Properties()->layout()->addWidget(m_Controls->Severity);
  Reset();
}

QAirwayObstructionWidget::~QAirwayObstructionWidget()
{
  delete m_Controls;
}

void QAirwayObstructionWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Severity->reset();
}

void QAirwayObstructionWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->enableInput(b);
}

void QAirwayObstructionWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->getValue(m_Controls->Action.GetSeverity());
}

void QAirwayObstructionWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QAirwayObstructionWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QAirwayObstructionWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QAirwayObstructionWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}