/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "actions/AcuteStressWidget.h"
#include "controls/ScalarWidget.h"
#include "controls/ScalarQuantityWidget.h"

#include "cdm/CommonDataModel.h"
#include "PhysiologyEngine.h"
#include "cdm/patient/actions/SEAcuteStress.h"
#include "cdm/properties/SEScalar0To1.h"

class QAcuteStressWidget::Controls
{
public:
  Controls() {}
  SEAcuteStress Action;
  QScalarWidget* Severity;
};

QAcuteStressWidget::QAcuteStressWidget(QPulse& qp, QWidget *parent, Qt::WindowFlags flags) : QActionWidget(qp, parent, flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, ScalarOptionWidget::None , this);
  Properties()->layout()->addWidget(m_Controls->Severity);
  Reset();
}

QAcuteStressWidget::~QAcuteStressWidget()
{
  delete m_Controls;
}

void QAcuteStressWidget::Reset()
{
  QActionWidget::Reset();
  m_Controls->Action.Clear();
  m_Controls->Severity->reset();
}

void QAcuteStressWidget::SetEnabled(bool b)
{
  QActionWidget::SetEnabled(b);
  m_Controls->Severity->enableInput(b);
}

void QAcuteStressWidget::ControlsToAction()
{
  QActionWidget::ControlsToAction();
  m_Controls->Severity->getValue(m_Controls->Action.GetSeverity());
}

void QAcuteStressWidget::AtSteadyState(PhysiologyEngine& pulse)
{
  // Nothing expected here
}
void QAcuteStressWidget::AtSteadyStateUpdateUI()
{
  // Nothing expected here
}

void QAcuteStressWidget::ProcessPhysiology(PhysiologyEngine& pulse)
{// This is called from a thread, you should NOT update UI here
  // This is where we pull data from pulse, and push any actions to it
  if (m_PassAction)
  {
    if (m_Controls->Action.IsValid())
      pulse.ProcessAction(m_Controls->Action);
    m_PassAction = false;
  }
}
void QAcuteStressWidget::PhysiologyUpdateUI()
{// This is called from a slot, you can update UI here

  // Nothing is expected to be in the environment
}