include(ExternalProject)
project(ExplorerSuperBuild)

set(DEPENDENCIES)

set( Qt5_DIR "" CACHE PATH "Path to Qt" )

if(ENABLE_PARAVIEW)
  set( ParaView_DIR "" CACHE PATH "Path to ParaView" )
  set( ParaView_FOUND FALSE)
  if(ParaView_DIR)
    ## Make sure this is a good ParaView dir
    if ( IS_DIRECTORY ${ParaView_DIR} )
      message(STATUS "Looking for your ParaView...")
      find_package( ParaView NO_MODULE )
      if ( ParaView_FOUND )
        message(STATUS "I found your ParaView!")
        find_package(Qt5 COMPONENTS Core Widgets Charts REQUIRED)
      else()
       message(STATUS "I could not find your ParaView!")
      endif()
    else()
      message(STATUS "Your ParaView_DIR is not a directory...")
      set( ParaView_FOUND FALSE)
    endif()
  endif()

  if(NOT ParaView_FOUND)
    set( ParaView_DIR "${CMAKE_BINARY_DIR}/ParaView-build" CACHE PATH "Path to ParaView" )
    message(STATUS "Downloading and build ParaView.")
    
    find_package(Qt5 COMPONENTS Core Widgets Charts REQUIRED)
    # Use the Qt that ParaView uses
    ExternalProject_Add(ParaView
      PREFIX ParaView
      GIT_REPOSITORY https://gitlab.kitware.com/paraview/paraview.git
      GIT_TAG v5.4.1
      GIT_SHALLOW 1
      BINARY_DIR ${CMAKE_BINARY_DIR}/ParaView-build
      INSTALL_DIR ${CMAKE_INSTALL_PREFIX}
      CMAKE_ARGS 
        -Wno-dev
        -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
        -DCMAKE_INSTALL_PREFIX=${CMAKE_INSTALL_PREFIX}
        -DBUILD_EXAMPLES:BOOL=OFF
        -DBUILD_TESTING:BOOL=OFF
        -DPARAVIEW_USE_QTHELP:BOOL=OFF
        -DPARAVIEW_ENABLE_EMBEDDED_DOCUMENTATION:BOOL=OFF
        -DPARAVIEW_QT_VERSION=5
        -DQt5_DIR=${Qt5_DIR}
    )
    list(APPEND DEPENDENCIES "ParaView")
  endif()
endif()

set( Pulse_DIR "" CACHE PATH "Path to Pulse" )
set( Pulse_FOUND FALSE)
if(Pulse_DIR)
  ## Make sure this is a good ParaView dir
  if ( IS_DIRECTORY ${Pulse_DIR} )
    message(STATUS "Looking for your Pulse...")
    find_package(Pulse NO_MODULE)
    if ( Pulse_FOUND )
      message(STATUS "I found your Pulse!")
    else()
     message(STATUS "I could not find your Pulse!")
    endif()
  else()
    message(STATUS "Your Pulse_DIR is not a directory...")
    set( Pulse_FOUND FALSE)
  endif()
endif()

if(NOT Pulse_FOUND)
  set( Pulse_DIR "${CMAKE_BINARY_DIR}/Pulse-build" CACHE PATH "Path to Pulse" )
  message(STATUS "Downloading and build Pulse.")
  ExternalProject_Add(Pulse
    PREFIX Pulse
    URL https://gitlab.kitware.com/physiology/engine/-/archive/REL_2_3_0/engine-REL_2_3_0.zip
    URL_MD5 9cdfe080ba0681a27a6404c8b64d768e
    BINARY_DIR ${CMAKE_BINARY_DIR}/Pulse-build
    CMAKE_ARGS
      -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
      -DCMAKE_INSTALL_PREFIX=${CMAKE_INSTALL_PREFIX}
      -DPULSE_DOWNLOAD_BASELINES:BOOL=OFF
      
    INSTALL_COMMAND cmake -E echo "Skipping install step."
  )
  list(APPEND DEPENDENCIES "Pulse")
endif()

find_package(Qt5 COMPONENTS Core Widgets Charts REQUIRED)
# Let's see if we have everything we need and the Superbuild is not necessary
if(NOT DEPENDENCIES)
  set(DOING_SUPERBUILD FALSE)
  return()
endif()
set(DOING_SUPERBUILD TRUE)
if(MSVC OR XCode)
  # For multi configuration IDE environments start with release
  set(CMAKE_CONFIGURATION_TYPES Release CACHE STRING INTERNAL FORCE )
endif()


ExternalProject_Add(PulseExplorer
  PREFIX PulseExplorer
  DEPENDS ${DEPENDENCIES}
  SOURCE_DIR ${CMAKE_CURRENT_SOURCE_DIR}
  BINARY_DIR ${CMAKE_BINARY_DIR}/PulseExplorer-build
  CMAKE_ARGS
    -DDO_SUPERBUILD:BOOL=OFF
    -DCMAKE_PREFIX_PATH:STRING=${CMAKE_PREFIX_PATH}
    -DCMAKE_INSTALL_PREFIX:STRING=${CMAKE_INSTALL_PREFIX}
    -DCMAKE_BUILD_TYPE:STRING=${CMAKE_BUILD_TYPE}
    
    -DENABLE_PARAVIEW:BOOL=${ENABLE_PARAVIEW}
    -DParaView_DIR:PATH=${ParaView_DIR}
    -DQt5_DIR=${Qt5_DIR}
    -DPulse_DIR:PATH=${Pulse_DIR}
  INSTALL_DIR ${CMAKE_INSTALL_PREFIX}
)