/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QWidget>
#include <QHBoxLayout>
#include <QCheckBox>
#include <QLabel>
#include <QDoubleSpinBox>
#include <QSpacerItem>
#include <QComboBox>
#include <QRadioButton>

#include "cdm/CommonDataModel.h"
#include "cdm/properties/SEScalar.h"


enum class ScalarOptionWidget { None, Check, Radio };

class QScalarWidget : public QWidget
{
  Q_OBJECT
public:
  explicit QScalarWidget(const QString& name, double min, double max, double step, ScalarOptionWidget optWidget=ScalarOptionWidget::Check, QWidget *parent = nullptr, bool seperate_label = false);

  void reset();
  bool isChecked();

  void setDecimals(int prec);
  void setValue(const SEScalar& s);
  void getValue(SEScalar& s);
  void enableInput(bool b);
  void fullDisable();

  const QRadioButton* getRadioButton() { return m_Radio; }

public slots:
  void checkProperty(bool b);

protected:
  void enableInput(bool check, bool value);

  QHBoxLayout*    m_Layout;
  QCheckBox*      m_Check;
  QRadioButton*   m_Radio;
  QLabel*         m_Label;
  QDoubleSpinBox* m_Value;
  QSpacerItem*    m_Spacer1;
  QSpacerItem*    m_Spacer2;
  double          m_LastValue;
};

class QScalarConvertWidget : public QWidget
{
  Q_OBJECT
public:
  explicit QScalarConvertWidget(QWidget *parent = nullptr) : QWidget(parent) {};

protected slots:
  virtual void convert() = 0;
  virtual void checkProperty(bool b) = 0;
};
