/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QDockWidget>
#include "QPulse.h"
#include "QPulsePlot.h"

namespace Ui {
  class PlotSetWidget;
}

class QPlotSetWidget : public QDockWidget, public PulseListener
{
    Q_OBJECT
public:
  explicit QPlotSetWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QPlotSetWidget();

  void Reset();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI();// Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components

signals:
protected slots:
  void SwitchPlot();
  void AddPlot();
  void RemovePlot();
  void AddDataRequest();
  void CancelDataRequest();
private:
  class Controls;
  Controls* m_Controls;
};

