/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ExplorerIntroWidget.h"
#include "ui_ExplorerIntro.h"

#include "cdm/CommonDataModel.h"
#include "cdm/utils/FileUtils.h"

class QExplorerIntroWidget::Controls : public Ui::ExplorerIntroWidget
{
public:
};

QExplorerIntroWidget::QExplorerIntroWidget(QWidget *parent, Qt::WindowFlags flags) : QDockWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->setupUi(this);

  m_Controls->LoadShowcase->setEnabled(true);
  m_Controls->ShowcaseComboBox->setEnabled(true);
  m_Controls->LoadScenario->setEnabled(true);
  m_Controls->LoadEngineState->setEnabled(true);
  m_Controls->LoadPatientEditor->setEnabled(true);
  QPixmap pic("resource/pulse_logo.png");
  m_Controls->Icon->setPixmap(pic);

  connect(m_Controls->LoadShowcase, SIGNAL(clicked()), parentWidget(), SLOT(StartShowcase()));
  connect(m_Controls->LoadScenario, SIGNAL(clicked()), parentWidget(), SLOT(SetupScenarioEditor()));
  connect(m_Controls->LoadEngineState, SIGNAL(clicked()), parentWidget(), SLOT(SetupEngineState()));
  connect(m_Controls->LoadPatientEditor, SIGNAL(clicked()), parentWidget(), SLOT(SetupPatientEditor()));
}

QExplorerIntroWidget::~QExplorerIntroWidget()
{
  delete m_Controls;
}

QString QExplorerIntroWidget::GetSelectedShowcase()
{
  return m_Controls->ShowcaseComboBox->currentText();
}
