/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"
#include <set>


namespace Ui {
  class DataRequestViewWidget;
}

class QDataRequestViewWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QDataRequestViewWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QDataRequestViewWidget();

  void Reset();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI();// Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components

signals:
protected slots:
  void Tile();
  void NewPlotSet();

private:
  class Controls;
  Controls* m_Controls;
};
