/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"
class SECondition;
class SEConditionManager;

namespace Ui {
  class ConditionsEditorWidget;
}

class QConditionsEditorWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QConditionsEditorWidget(QPulse& qp, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QConditionsEditorWidget();

  void Reset();
  void EnableInput(bool b);
  void ConditionsToControls();
  void ControlsToConditions();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI(); // Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse) {}
  void PhysiologyUpdateUI() {} // Main Window will call this to update UI Components

protected:
  void EnableConverter(bool b);

private:
  class Controls;
  Controls* m_Controls;
  
};