/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ConditionWidget.h"
#include "ui_Condition.h"
#include <QMessageBox>
#include "controls/ScalarWidget.h"

class QConditionWidget::Controls : public Ui::ConditionWidget
{
public:
  Controls() {}
};

QConditionWidget::QConditionWidget(QWidget *parent, Qt::WindowFlags flags) : QWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->setupUi(this);

  connect(m_Controls->Enabled, SIGNAL(toggled(bool)), this, SLOT(enableConditionInput(bool)));
}

QConditionWidget::~QConditionWidget()
{
  delete m_Controls;
}

void QConditionWidget::reset()
{
  m_Controls->Enabled->setChecked(false);
  setEnabled(true);
}

bool QConditionWidget::isSelected()
{
  return m_Controls->Enabled->isChecked();
}

void QConditionWidget::setEnabled(bool b)
{
  QWidget::setEnabled(b);
  m_Controls->Enabled->setEnabled(b);
  enableProperties(b?m_Controls->Enabled->isChecked():false);
}

void QConditionWidget::enableCondition(bool b)
{
  m_Controls->Enabled->setChecked(b);
}

void QConditionWidget::enableConditionInput(bool b)
{
  enableProperties(b);
}

