/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicVentricularSystolicDysfunctionWidget.h"
#include <QMessageBox>

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEChronicVentricularSystolicDysfunction.h"

class QChronicVentricularSystolicDysfunctionWidget::Controls
{
public:
  Controls() {}
  SEChronicVentricularSystolicDysfunction Condition;
};

QChronicVentricularSystolicDysfunctionWidget::QChronicVentricularSystolicDysfunctionWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  reset();
}

QChronicVentricularSystolicDysfunctionWidget::~QChronicVentricularSystolicDysfunctionWidget()
{
  delete m_Controls;
}

void QChronicVentricularSystolicDysfunctionWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  enableProperties(false);
}

void QChronicVentricularSystolicDysfunctionWidget::enableProperties(bool b)
{
}
void QChronicVentricularSystolicDysfunctionWidget::enableConverter(bool b)
{
}

const SECondition& QChronicVentricularSystolicDysfunctionWidget::getCondition()
{
  m_Controls->Condition.Clear();
  return m_Controls->Condition;
}

void QChronicVentricularSystolicDysfunctionWidget::setCondition(const SECondition& c)
{
  QConditionWidget::enableCondition(c.IsActive());
}

