/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicRenalStenosisWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEChronicRenalStenosis.h"
#include "cdm/properties/SEScalar0To1.h"

class QChronicRenalStenosisWidget::Controls
{
public:
  Controls() {}
  SEChronicRenalStenosis Condition;
  QScalarWidget* LeftKidneySeverity;
  QScalarWidget* RightKidneySeverity;
};

QChronicRenalStenosisWidget::QChronicRenalStenosisWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->LeftKidneySeverity = new QScalarWidget("Left Kidney Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  m_Controls->RightKidneySeverity = new QScalarWidget("Right Kidney Severity", 0, 1, 0.1, ScalarOptionWidget::None, this);
  layout()->addWidget(m_Controls->LeftKidneySeverity);
  layout()->addWidget(m_Controls->RightKidneySeverity);
  reset();
}

QChronicRenalStenosisWidget::~QChronicRenalStenosisWidget()
{
  delete m_Controls;
}

void QChronicRenalStenosisWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->LeftKidneySeverity->reset();
  m_Controls->RightKidneySeverity->reset();
  enableProperties(false);
}

void QChronicRenalStenosisWidget::enableProperties(bool b)
{
  m_Controls->LeftKidneySeverity->enableInput(b);
  m_Controls->RightKidneySeverity->enableInput(b);
}
void QChronicRenalStenosisWidget::enableConverter(bool b)
{
}

const SECondition& QChronicRenalStenosisWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->LeftKidneySeverity->getValue(m_Controls->Condition.GetLeftKidneySeverity());
  m_Controls->RightKidneySeverity->getValue(m_Controls->Condition.GetRightKidneySeverity());
  return m_Controls->Condition;
}

void QChronicRenalStenosisWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEChronicRenalStenosis&)(c));
  m_Controls->LeftKidneySeverity->setValue(m_Controls->Condition.GetLeftKidneySeverity());
  m_Controls->RightKidneySeverity->setValue(m_Controls->Condition.GetRightKidneySeverity());
  QConditionWidget::enableCondition(c.IsActive());
}

