/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/properties/SEScalar.h"

QScalarWidget::QScalarWidget(const QString& name, double min, double max, double step, bool check, QWidget *parent) : QWidget(parent)
{
  setAutoFillBackground(true);
  m_Layout = new QHBoxLayout(this);
  m_Layout->setSpacing(6);
  m_Layout->setContentsMargins(-1, 6, -1, 6);

  QSizePolicy sizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
  sizePolicy.setHorizontalStretch(0);
  sizePolicy.setVerticalStretch(0);
  if (check)
  {
    m_Check = new QCheckBox(name,this);
    sizePolicy.setHeightForWidth(m_Check->sizePolicy().hasHeightForWidth());
    m_Check->setSizePolicy(sizePolicy);
    m_Label = nullptr;
    m_Layout->addWidget(m_Check);
    connect(m_Check, SIGNAL(toggled(bool)), this, SLOT(checkProperty(bool)));
  }
  else
  {
    m_Check = nullptr;
    m_Label = new QLabel(name,this);
    sizePolicy.setHeightForWidth(m_Label->sizePolicy().hasHeightForWidth());
    m_Label->setSizePolicy(sizePolicy);
    m_Layout->addWidget(m_Label);
  }
  m_Spacer1 = new QSpacerItem(40,30, QSizePolicy::Expanding, QSizePolicy::Maximum);
  m_Layout->addItem(m_Spacer1);
  m_Value = new QDoubleSpinBox(this); 
  m_Value->setSingleStep(step);
  if(check)
    m_Value->setSpecialValueText("nan");
  m_Value->setMinimum(check ? min-step : min);
  m_Value->setMaximum(max);
  m_Value->setMinimumSize(QSize(70, 22));
  m_Value->setMaximumSize(QSize(70, 22));
  m_Value->setDecimals(2);
  m_Layout->addWidget(m_Value);
  m_Spacer2 = new QSpacerItem(76, 20, QSizePolicy::Fixed, QSizePolicy::Maximum);
  m_Layout->addItem(m_Spacer2);
  setLayout(m_Layout);
  reset();
}
void QScalarWidget::reset()
{
  if (m_Check != nullptr)
    m_Check->setChecked(false);
  enableInput(true, false);
  m_Value->setValue(m_Value->minimum());
  m_LastValue = m_Value->minimum();
}

bool QScalarWidget::isChecked()
{
  if (m_Check != nullptr)
    return m_Check->isChecked();
  return true;
}

void QScalarWidget::setValue(const SEScalar& s)
{
  if (s.IsValid())
  {
    m_Value->setEnabled(true);
    if (m_Check != nullptr)
      m_Check->setChecked(true);
    m_Value->setValue(s.GetValue());
    m_LastValue = s.GetValue();
  }
  else
  {
    m_Value->setValue(m_Value->minimum());
    if (m_Check != nullptr)
      m_Check->setChecked(false);
    m_LastValue = m_Value->minimum();
  }
}

void QScalarWidget::getValue(SEScalar& s)
{
  if (m_Check != nullptr && m_Value->value() == m_Value->minimum())
  {
    s.Invalidate();
    return;//Skip it!! not a valid value as per the bounds
  }
  s.SetValue(m_Value->value());
}

void QScalarWidget::enableInput(bool b)
{
  enableInput(b, b);
}
void QScalarWidget::enableInput(bool check, bool value)
{
  if (m_Check != nullptr)
    m_Check->setEnabled(check);
  m_Value->setEnabled(value);
}

void QScalarWidget::checkProperty(bool b)
{
  m_Value->setEnabled(b);
  if (!b)
  {
    m_LastValue = m_Value->value();
    m_Value->setValue(m_Value->minimum());
  }
  else
    m_Value->setValue(m_LastValue);
}