/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QWidget>
#include <QHBoxLayout>
#include <QCheckBox>
#include <QLabel>
#include <QDoubleSpinBox>
#include <QSpacerItem>
#include <QComboBox>

#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/properties/SEScalar.h"

template <typename Unit>
class QScalarQuantityWidget : public QScalarConvertWidget
{
public:
  explicit QScalarQuantityWidget(const QString& name, double min, double max, double step, const Unit& unit, bool check = true, QWidget *parent = nullptr);

  void reset();
  bool isChecked();

  void addUnit(const Unit& unit);
  void setValue(const SEScalarQuantity<Unit>& s);
  void getValue(SEScalarQuantity<Unit>& s);
  void enableInput(bool b);
  void enableConverter(bool b);

protected slots:
  void checkProperty(bool b);
  void convert();

  void enableInput(bool check, bool value);
  void updateMinMax();

  QHBoxLayout*    m_Layout;
  QCheckBox*      m_Check;
  QLabel*         m_Label;
  QDoubleSpinBox* m_Value;
  QSpacerItem*    m_Spacer;
  QComboBox*      m_Unit;
  
  bool            m_Convert;
  double          m_Min;
  double          m_Max;
  double          m_Step;
  double          m_LastValue;
  int             m_LastUnitIndex;
  const Unit&     m_DefaultUnit;
  std::vector<const Unit*> m_Units;

};


#include "controls/ScalarQuantityWidget.inl"