/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QObject>
#include <QDockWidget>
#include "QPulse.h"

namespace Ui {
  class DataRequestsWidget;
}

class QDataRequestsWidget : public QDockWidget, public PulseListener
{
  Q_OBJECT
public:
  QDataRequestsWidget(QTextEdit& log, QWidget *parent = Q_NULLPTR, Qt::WindowFlags flags = Qt::WindowFlags());
  virtual ~QDataRequestsWidget();

  void Reset();

  void AtSteadyState(PhysiologyEngine& pulse);
  void AtSteadyStateUpdateUI();// Main Window will call this to update UI Components
  void ProcessPhysiology(PhysiologyEngine& pulse);
  void PhysiologyUpdateUI();// Main Window will call this to update UI Components

signals:
protected slots:
  void ChangePlot(int);

  void BuildGraphs(PhysiologyEngine& pulse);

private:
  class Controls;
  Controls* m_Controls;
};