/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#pragma once

#include <QFrame>
#include <QGridLayout>
#include <QParallelAnimationGroup>
#include <QScrollArea>
#include <QToolButton>
#include <QWidget>

class QCollapsableWidget : public QWidget
{
  Q_OBJECT
public:
  explicit QCollapsableWidget(const QString & title = "", const int animationDuration = 120, QWidget *parent = 0);
  void setContentLayout(QLayout & contentLayout);
  void expand(bool b);

protected:
  QGridLayout mainLayout;
  QToolButton toggleButton;
  QFrame headerLine;
  QParallelAnimationGroup toggleAnimation;
  QScrollArea contentArea;
  int animationDuration{ 300 };

};