/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "LobarPneumoniaWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SELobarPneumonia.h"
#include "cdm/properties/SEScalar0To1.h"

class QLobarPneumoniaWidget::Controls
{
public:
  Controls() {}
  QScalarWidget* Severity;
  QScalarWidget* LeftLungAffected;
  QScalarWidget* RightLungAffected;
  SELobarPneumonia Condition;
};

QLobarPneumoniaWidget::QLobarPneumoniaWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->Severity = new QScalarWidget("Severity", 0, 1, 0.1, false, this);
  m_Controls->LeftLungAffected = new QScalarWidget("Left Lung Affected", 0, 1, 0.1, false, this);
  m_Controls->RightLungAffected = new QScalarWidget("Right Lung Affected", 0, 1, 0.1, false, this);
  layout()->addWidget(m_Controls->Severity);
  layout()->addWidget(m_Controls->LeftLungAffected);
  layout()->addWidget(m_Controls->RightLungAffected);
  reset();
}

QLobarPneumoniaWidget::~QLobarPneumoniaWidget()
{
  delete m_Controls;
}

void QLobarPneumoniaWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->Severity->reset();
  m_Controls->LeftLungAffected->reset();
  m_Controls->RightLungAffected->reset();
  enableProperties(false);
}

void QLobarPneumoniaWidget::enableProperties(bool b)
{
  m_Controls->Severity->enableInput(b);
  m_Controls->LeftLungAffected->enableInput(b);
  m_Controls->RightLungAffected->enableInput(b);
}
void QLobarPneumoniaWidget::enableConverter(bool b)
{
}

const SECondition& QLobarPneumoniaWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->Severity->getValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->getValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->getValue(m_Controls->Condition.GetRightLungAffected());
  return m_Controls->Condition;
}

void QLobarPneumoniaWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SELobarPneumonia&)(c));
  m_Controls->Severity->setValue(m_Controls->Condition.GetSeverity());
  m_Controls->LeftLungAffected->setValue(m_Controls->Condition.GetLeftLungAffected());
  m_Controls->RightLungAffected->setValue(m_Controls->Condition.GetRightLungAffected());
  QConditionWidget::enableCondition(c.IsActive());
}

