/* Distributed under the Apache License, Version 2.0.
See accompanying NOTICE file for details.*/
#include "ChronicObstructivePulmonaryDiseaseWidget.h"
#include "controls/ScalarWidget.h"

#include "cdm/CommonDataModel.h"
#include "cdm/patient/conditions/SEChronicObstructivePulmonaryDisease.h"
#include "cdm/properties/SEScalar0To1.h"

class QChronicObstructivePulmonaryDiseaseWidget::Controls
{
public:
  Controls() {}
  SEChronicObstructivePulmonaryDisease Condition;
  QScalarWidget* BronchitisSeverity;
  QScalarWidget* EmphysemaSeverity;
};

QChronicObstructivePulmonaryDiseaseWidget::QChronicObstructivePulmonaryDiseaseWidget(QWidget *parent, Qt::WindowFlags flags) : QConditionWidget(parent,flags)
{
  m_Controls = new Controls();
  m_Controls->BronchitisSeverity = new QScalarWidget("Bronchitis Severity", 0, 1, 0.1, false, this);
  m_Controls->EmphysemaSeverity = new QScalarWidget("Emphysema Severity", 0, 1, 0.1, false, this);
  layout()->addWidget(m_Controls->BronchitisSeverity);
  layout()->addWidget(m_Controls->EmphysemaSeverity);
  reset();
}

QChronicObstructivePulmonaryDiseaseWidget::~QChronicObstructivePulmonaryDiseaseWidget()
{
  delete m_Controls;
}

void QChronicObstructivePulmonaryDiseaseWidget::reset()
{
  QConditionWidget::reset();
  m_Controls->Condition.Clear();
  m_Controls->BronchitisSeverity->reset();
  m_Controls->EmphysemaSeverity->reset();
  enableProperties(false);
}

void QChronicObstructivePulmonaryDiseaseWidget::enableProperties(bool b)
{
  m_Controls->BronchitisSeverity->enableInput(b);
  m_Controls->EmphysemaSeverity->enableInput(b);
}
void QChronicObstructivePulmonaryDiseaseWidget::enableConverter(bool b)
{
}

const SECondition& QChronicObstructivePulmonaryDiseaseWidget::getCondition()
{
  m_Controls->Condition.Clear();
  m_Controls->BronchitisSeverity->getValue(m_Controls->Condition.GetBronchitisSeverity());
  m_Controls->EmphysemaSeverity->getValue(m_Controls->Condition.GetEmphysemaSeverity());
  return m_Controls->Condition;
}

void QChronicObstructivePulmonaryDiseaseWidget::setCondition(const SECondition& c)
{
  m_Controls->Condition.Copy((SEChronicObstructivePulmonaryDisease&)(c));
  m_Controls->BronchitisSeverity->setValue(m_Controls->Condition.GetBronchitisSeverity());
  m_Controls->EmphysemaSeverity->setValue(m_Controls->Condition.GetEmphysemaSeverity());
  QConditionWidget::enableCondition(c.IsActive());
}

