/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;

final class SampledImageReader {
    private static final Log LOG = LogFactory.getLog(SampledImageReader.class);

    private SampledImageReader() {
    }

    public static BufferedImage getStencilImage(PDImage pdImage, Paint paint) throws IOException {
        BufferedImage mask = SampledImageReader.getRGBImage(pdImage, null);
        BufferedImage masked = new BufferedImage(mask.getWidth(), mask.getHeight(), 2);
        Graphics2D g = masked.createGraphics();
        g.setPaint(paint);
        g.fillRect(0, 0, mask.getWidth(), mask.getHeight());
        g.dispose();
        int width = masked.getWidth();
        int height = masked.getHeight();
        WritableRaster raster = masked.getRaster();
        WritableRaster alpha = mask.getRaster();
        float[] transparent = new float[4];
        float[] alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if ((alphaPixel = alpha.getPixel(x, y, alphaPixel))[0] != 255.0f) continue;
                raster.setPixel(x, y, transparent);
            }
        }
        return masked;
    }

    public static BufferedImage getRGBImage(PDImage pdImage, COSArray colorKey) throws IOException {
        if (pdImage.isEmpty()) {
            throw new IOException("Image stream is empty");
        }
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int numComponents = colorSpace.getNumberOfComponents();
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        int bitsPerComponent = pdImage.getBitsPerComponent();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        WritableRaster raster = Raster.createBandedRaster(0, width, height, numComponents, new Point(0, 0));
        float[] defaultDecode = pdImage.getColorSpace().getDefaultDecode(8);
        if (bitsPerComponent == 8 && Arrays.equals(decode, defaultDecode) && colorKey == null) {
            return SampledImageReader.from8bit(pdImage, raster);
        }
        if (bitsPerComponent == 1 && colorKey == null) {
            return SampledImageReader.from1Bit(pdImage, raster);
        }
        return SampledImageReader.fromAny(pdImage, raster, colorKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage from1Bit(PDImage pdImage, WritableRaster raster) throws IOException {
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        byte[] output = ((DataBufferByte)raster.getDataBuffer()).getData();
        InputStream iis = null;
        try {
            BufferedImage rgbImage;
            int value1;
            int value0;
            iis = pdImage.createInputStream();
            boolean isIndexed = colorSpace instanceof PDIndexed;
            int rowLen = width / 8;
            if (width % 8 > 0) {
                ++rowLen;
            }
            if (isIndexed || decode[0] < decode[1]) {
                value0 = 0;
                value1 = -1;
            } else {
                value0 = -1;
                value1 = 0;
            }
            byte[] buff = new byte[rowLen];
            int idx = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                int readLen = iis.read(buff);
                block4: for (int r = 0; r < rowLen && r < readLen; ++r) {
                    byte value = buff[r];
                    int mask = 128;
                    for (int i = 0; i < 8; ++i) {
                        int bit = value & mask;
                        mask >>= 1;
                        int n = output[idx++] = bit == 0 ? value0 : value1;
                        if (++x == width) continue block4;
                    }
                }
                if (readLen == rowLen) continue;
                LOG.warn((Object)"premature EOF, image will be incomplete");
                break;
            }
            BufferedImage bufferedImage = rgbImage = colorSpace.toRGBImage(raster);
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage from8bit(PDImage pdImage, WritableRaster raster) throws IOException {
        InputStream input = pdImage.createInputStream();
        try {
            byte[][] banks = ((DataBufferByte)raster.getDataBuffer()).getBankData();
            int width = pdImage.getWidth();
            int height = pdImage.getHeight();
            int numComponents = pdImage.getColorSpace().getNumberOfComponents();
            int max = width * height;
            byte[] tempBytes = new byte[numComponents];
            for (int i = 0; i < max; ++i) {
                input.read(tempBytes);
                for (int c = 0; c < numComponents; ++c) {
                    banks[c][i] = tempBytes[0 + c];
                }
            }
            BufferedImage bufferedImage = pdImage.getColorSpace().toRGBImage(raster);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage fromAny(PDImage pdImage, WritableRaster raster, COSArray colorKey) throws IOException {
        PDColorSpace colorSpace = pdImage.getColorSpace();
        int numComponents = colorSpace.getNumberOfComponents();
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        int bitsPerComponent = pdImage.getBitsPerComponent();
        float[] decode = SampledImageReader.getDecodeArray(pdImage);
        MemoryCacheImageInputStream iis = null;
        try {
            iis = new MemoryCacheImageInputStream(pdImage.createInputStream());
            float sampleMax = (float)Math.pow(2.0, bitsPerComponent) - 1.0f;
            boolean isIndexed = colorSpace instanceof PDIndexed;
            float[] colorKeyRanges = null;
            BufferedImage colorKeyMask = null;
            if (colorKey != null) {
                colorKeyRanges = colorKey.toFloatArray();
                colorKeyMask = new BufferedImage(width, height, 10);
            }
            int padding = 0;
            if (width * numComponents * bitsPerComponent % 8 > 0) {
                padding = 8 - width * numComponents * bitsPerComponent % 8;
            }
            byte[] srcColorValues = new byte[numComponents];
            byte[] alpha = new byte[1];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    boolean isMasked = true;
                    for (int c = 0; c < numComponents; ++c) {
                        int value = (int)iis.readBits(bitsPerComponent);
                        if (colorKeyRanges != null) {
                            isMasked &= (float)value >= colorKeyRanges[c * 2] && (float)value <= colorKeyRanges[c * 2 + 1];
                        }
                        float dMin = decode[c * 2];
                        float dMax = decode[c * 2 + 1];
                        float output = dMin + (float)value * ((dMax - dMin) / sampleMax);
                        if (isIndexed) {
                            srcColorValues[c] = (byte)Math.round(output);
                            continue;
                        }
                        int outputByte = Math.round((output - Math.min(dMin, dMax)) / Math.abs(dMax - dMin) * 255.0f);
                        srcColorValues[c] = (byte)outputByte;
                    }
                    raster.setDataElements(x, y, srcColorValues);
                    if (colorKeyMask == null) continue;
                    alpha[0] = (byte)(isMasked ? 255 : 0);
                    colorKeyMask.getRaster().setDataElements(x, y, alpha);
                }
                iis.readBits(padding);
            }
            BufferedImage rgbImage = colorSpace.toRGBImage(raster);
            if (colorKeyMask != null) {
                BufferedImage bufferedImage = SampledImageReader.applyColorKeyMask(rgbImage, colorKeyMask);
                return bufferedImage;
            }
            BufferedImage bufferedImage = rgbImage;
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
        }
    }

    private static BufferedImage applyColorKeyMask(BufferedImage image, BufferedImage mask) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage masked = new BufferedImage(width, height, 2);
        WritableRaster src = image.getRaster();
        WritableRaster dest = masked.getRaster();
        WritableRaster alpha = mask.getRaster();
        float[] rgb = new float[3];
        float[] rgba = new float[4];
        float[] alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                src.getPixel(x, y, rgb);
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                alphaPixel = alpha.getPixel(x, y, alphaPixel);
                rgba[3] = 255.0f - alphaPixel[0];
                dest.setPixel(x, y, rgba);
            }
        }
        return masked;
    }

    private static float[] getDecodeArray(PDImage pdImage) throws IOException {
        COSArray cosDecode = pdImage.getDecode();
        float[] decode = null;
        if (cosDecode != null) {
            int numberOfComponents = pdImage.getColorSpace().getNumberOfComponents();
            if (cosDecode.size() != numberOfComponents * 2) {
                if (pdImage.isStencil() && cosDecode.size() >= 2 && cosDecode.get(0) instanceof COSNumber && cosDecode.get(1) instanceof COSNumber) {
                    float decode0 = ((COSNumber)cosDecode.get(0)).floatValue();
                    float decode1 = ((COSNumber)cosDecode.get(1)).floatValue();
                    if (decode0 >= 0.0f && decode0 <= 1.0f && decode1 >= 0.0f && decode1 <= 1.0f) {
                        LOG.warn((Object)("decode array " + cosDecode + " not compatible with color space, using the first two entries"));
                        return new float[]{decode0, decode1};
                    }
                }
                LOG.error((Object)("decode array " + cosDecode + " not compatible with color space, using default"));
            } else {
                decode = cosDecode.toFloatArray();
            }
        }
        if (decode == null) {
            return pdImage.getColorSpace().getDefaultDecode(pdImage.getBitsPerComponent());
        }
        return decode;
    }
}

