## En Route Mechanical Ventilation Validation

### Introduction

Additional validation was performed for the management of mechanically ventilated patients during transport, covering a range of clinical conditions and injuries.

### Data Sources

Empirical data and published literature were used where available. When direct data were unavailable, expected patient outcomes were verified by clinical subject matter experts @cite BransonSME, @cite ChatburnSME.

### Results

#### With Patient Effort

The following scenarios include spontaneous breathing (i.e., active respiratory muscle pressure) where appropriate.

@secreflist
  @refitem EnRouteCareScenario1 "Scenario 1: Mild ARDS with Progressive Fall in Oxygenation"
  @refitem EnRouteCareScenario2 "Scenario 2: Moderate COPD with Subsequent Bronchospasm"
  @refitem EnRouteCareScenario3 "Scenario 3: Mild TBI with worsening ARDS"
  @refitem EnRouteCareScenario4 "Scenario 4: Moderate ARDS with Tension Pneumothorax"
  @refitem EnRouteCareScenario5 "Scenario 5: Mild ARDS with Right Mainstem Intubation"
  @refitem EnRouteCareScenario6 "Scenario 6: Hypoxemic Respiratory Failure - Pneumonia"
  @refitem EnRouteCareScenario7 "Scenario 7: Hypoxemic Respiratory Failure Plugged ETT"
@endsecreflist

#### Without Patient Effort

The following scenarios were repeated without spontaneous breathing (i.e., no patient-generated respiratory effort) to support comparative validation. Scenario 4 features an apneic patient by design and is therefore unchanged in the no spontaneous effort set.

@secreflist
  @refitem EnRouteCareScenario1_NoSpontaneous "Scenario 1 - NoSpontaneous: Mild ARDS with Progressive Fall in Oxygenation"
  @refitem EnRouteCareScenario2_NoSpontaneous "Scenario 2 - NoSpontaneous: Moderate COPD with Subsequent Bronchospasm"
  @refitem EnRouteCareScenario3_NoSpontaneous "Scenario 3 - NoSpontaneous: Mild TBI with worsening ARDS"
  @refitem EnRouteCareScenario5_NoSpontaneous "Scenario 5 - NoSpontaneous: Mild ARDS with Right Mainstem Intubation"
  @refitem EnRouteCareScenario6_NoSpontaneous "Scenario 6 - NoSpontaneous: Hypoxemic Respiratory Failure - Pneumonia"
  @refitem EnRouteCareScenario7_NoSpontaneous "Scenario 7 - NoSpontaneous: Hypoxemic Respiratory Failure Plugged ETT"
@endsecreflist