Publications {#published}
=======

To acknowledge the Pulse Physiology Engine as a platform, please cite the <a href="https://pulse.kitware.com/">Pulse website</a>.

For work that uses or incorporates Pulse, please include the following citation:

- Bray, Aaron, Jeffrey B. Webb, Andinet Enquobahrie, Jared Vicory, Jerry Heneghan, Robert Hubal, Stephanie TerMaath, Philip Asare, and Rachel B. Clipp. "Pulse Physiology Engine: an Open-Source Software Platform for Computational Modeling of Human Medical Simulation." SN Comprehensive Clinical Medicine. 2019. https://doi.org/10.1007/s42399-019-00053-w

Below is a list of publications that focus on the development or significant use of the Pulse Physiology Engine. These works cover a range of topics, including interface design, model development, and integration with various applications. Publications before 2018 may focus on the precursor to Pulse, BioGears, as authors Clipp, Webb, and Bray transitioned to the core Pulse development team at Kitware.

If you have a publication that you would like added to this list, please email <a href="mailto:comm@kitware.com">comm@kitware.com</a>.

Relevant Publications:

- Bray, Aaron, Emily Veenhuis, Brian Hu, PhD, David Joy, Bill Ray, Jeffrey B. Webb, Rachel B. Clipp, PhD, and Arslan Basharat, PhD. "An Artificial Intelligence Solution to Human-Trusted Medical Triage Decision Making." Presented at the Military Health System Research Symposium (MHSRS), 2024.
- Bray, Aaron, Jared Vicory, PhD, Matthew Bernstein, Emily Veenhuis, Barry Ravichandran, Bob Marinier, PhD, Alyssa Tanaka, PhD, and Rachel Clipp, PhD. "Predicting the Need for Life-Saving Interventions During Triage Using a Deep Time-Series Predictor Pipeline." Presented at the Military Health System Research Symposium (MHSRS), 2024.
- Chheang, Vuthea, Danny Schott, Patrick Saalfeld, Lukas Vradelis, Tobias Huber, Florentine Huettl, Hauke Lang, Bernhard Preim, and Christian Hansen. "Advanced Liver Surgery Training in Collaborative VR Environments." Computers & Graphics 119 (2024): 103879. https://doi.org/10.1016/j.cag.2024.01.006.
- Kockwelp, Pascal, Marcel Meyerheim, Dimitar Valkov, Marvin Mergen, Anna Junga, Antonio Krüger, Bernhard Marschall, Markus Holling, and Benjamin Risse. "VR-based Competence Training at Scale: Teaching Clinical Skills in the Context of Virtual Brain Death Examination." Proceedings of the ACM on Human-Computer Interaction 8, no. EICS (2024): 1–31. https://doi.org/10.1145/3664635.
- Ward, Isaac R., Dylan M. Asmar, Mansur Arief, Jana Krystofova Mike, and Mykel J. Kochenderfer. "Optimal Control of Mechanical Ventilators with Learned Respiratory Dynamics." In 2024 IEEE 37th International Symposium on Computer-Based Medical Systems (CBMS), 192–98. IEEE, 2024. https://doi.org/10.1109/CBMS61543.2024.00040.
- Tolmachev, Ivan Vladislavovich, Aleksey Vladimirovich Anisin, Anatoliy Mikhailovich Bala, Denis Aleksandrovich Vrazhnov, Aleksandr Vasilievich Shapovalov, Mikhail Yuryevich Kotlovskiy, Vladislav Vitalievich Laptev, and Konstantin Stanislavovich Brazovskiy. "Mathematical Modeling of Physiological Parameters in Traumatic Shock Caused by Lower Limb Blast Injury." Bulletin of Siberian Medicine 22, no. 4 (2024): 122–29. https://doi.org/10.20538/1682-0363-2023-4-122-129.
- Monticelli, Jonas, Jorge Wagner, Anderson Maciel, Rafael P. Torchelsen, Carla Freitas, and Luciana Nedel. "Immersive Visualization Interface for Endoscopy Analytics and Debriefing." In Proceedings of the 25th Symposium on Virtual and Augmented Reality, 166–73. New York, NY: Association for Computing Machinery, 2024. https://doi.org/10.1145/3625008.3625038.
- Moore, Jacob, Harald Scheirich, Shreeraj Jadhav, Andinet Enquobahrie, Beatriz Paniagua, Andrew Wilson, Aaron Bray, Ganesh Sankaranarayanan, and Rachel B. Clipp. "The Interactive Medical Simulation Toolkit (iMSTK): An Open Source Platform for Surgical Simulation." Frontiers in Virtual Reality 4 (2023): 1130156. https://doi.org/10.3389/frvir.2023.1130156.
- Chimakurthi, Satish, Jeffrey B. Webb, Jeffrey Heylmun, Steve Maas, Brandon Casper, and Matthew Babina. "A Computational Framework for Multiphysics Modeling of Underwater Explosions and Their Impact on Biomechanics and Physiology of Human Lungs." Presented at the Military Health System Research Symposium (MHSRS), 2023.
- Bernstein, Matthew, Aaron Bray, and Rachel B. Clipp. "Machine Learning Approach to Predict Cardiovascular Collapse in Hemorrhage Patients." Presented at the 18th International Symposium on Computer Methods in Biomechanics and Biomedical Engineering (CMBBE), 2023. https://www.cmbbe-symposium.com/2023/wp-content/uploads/sites/14/2023/04/CMBBE23_Abstract_book_posters_small.pdf (page 102).
- Webb, Jeffrey B., Aaron Bray, and Rachel B. Clipp. "Design and Implementation of a Generic Circuit Solver for Physiological Lumped-Parameter Modeling." In 2023 Annual Modeling and Simulation Conference (ANNSIM), 381–92. IEEE, 2023. https://ieeexplore.ieee.org/abstract/document/10155226.
- Jin, Xin, Srinivas Laxminarayan, Sridevi Nagaraja, Anders Wallqvist, and Jaques Reifman. "Development and Validation of a Mathematical Model to Simulate Human Cardiovascular and Respiratory Responses to Battlefield Trauma." International Journal for Numerical Methods in Biomedical Engineering 39, no. 1 (2023): e3662. https://doi.org/10.1002/cnm.3662.
- Cornish, Rob, Muhammad Faaiz Taufiq, Arnaud Doucet, and Chris Holmes. "Causal Falsification of Digital Twins." arXiv Preprint arXiv:2301.07210 (2023). https://doi.org/10.48550/arXiv.2301.07210.
- Webb, Jeffrey B., Aaron Bray, Harald Scheirich, Joseph VanPelt, Rachel B. Clipp, Justina Gerard, and Stefan Frembgen. "Implementation of a Dynamic and Extensible Mechanical Ventilator Model for Real-Time Physiological Simulation." In 2022 Annual Modeling and Simulation Conference (ANNSIM), 282–93. IEEE, 2022. https://doi.org/10.23919/ANNSIM55834.2022.9859325.
- Harrison, Shawn, Anna Bulysheva, Brett Newman, Michelle Audette, Rachel Clipp, Jeff Webb, and Marsha Mitchum. "Integrative Physiology-Coupled Pilot-Centered Flight Simulation." In 2022 Annual Modeling and Simulation Conference (ANNSIM), 383–91. IEEE, 2022. https://doi.org/10.23919/ANNSIM55834.2022.9859358.
- Kockwelp, Pascal, Anna Junga, Dimitar Valkov, Bernhard Marschall, Markus Holling, and Benjamin Risse. "Towards VR Simulation-Based Training in Brain Death Determination." In 2022 IEEE Conference on Virtual Reality and 3D User Interfaces Abstracts and Workshops (VRW), 287–92. IEEE, 2022. https://doi.org/10.1109/VRW55335.2022.00065.
- Audette, M.A., S. Harrison, M. Frazier, N. Watkins, A. Tinelli, P. Clark, K. Neale, J. Webb, A. Bray, A.A. Bulysheva, B.A. Newman, and R.B. Clipp. "Toward a Coupled Integrative Physiology-Flight-OBOGS Simulation for the Analysis and Mitigation of Hypoxic Events in Fighter Aircraft." Presented at the Military Health System Research Symposium (MHSRS), 2021.
- Clipp, Rachel, Aaron Bray, and Jeffrey B. Webb. "Recent Improvements to Hemorrhage Modeling in Full-Body Physiology Simulation." In Technical Proceedings of the International Meeting on Simulation in Healthcare (IMSH 2022). Los Angeles, CA: Conference Proceedings for the International Meeting for Simulation in Healthcare, 2021.
- Clipp, Rachel B.P., Aaron Bray, Bradley P. Feiger, Umar M. Qureshi, and Jeffrey B. Webb. "Recent Advances in the Pulse Physiology Engine." Presented at the SIAM Conference on Computational Science and Engineering (CSE21), 2021.
- Heneghan, Jerry, Brandon Conover, Christine Heneghan, Chris Wall, Jason Cisarano, Wesley Pretsch, William N. Vasios III, Gene Hobbs, and Robert Hubal. "nXcomms: Advancing Communications with Virtual Patients." In Proceedings of the Interservice/Industry Training, Simulation, and Education Conference (I/ITSEC), Paper No. 21251, 1–11, 2021.
- Bray, Aaron. "Pulse Physiology Engine: An Interactive Human Physiology Simulator." Presented at JupyterCon, 2020. https://www.youtube.com/watch?v=jPh2NL_tZgc.
- Clipp, Rachel B., Aaron Bray, and Jeffrey B. Webb. "An Integrated Model for Hemorrhagic Shock and Fluid Resuscitation." Presented at the Military Health System Research Symposium (MHSRS), 2020.
- Webb, Jeffrey B., Aaron Bray, Philip K. Asare, Rachel B. Clipp, Yatin B. Mehta, Sudheer Penupolu, Aalpen A. Patel, and S. Mark Poler. "Computational Simulation to Assess Patient Safety of Uncompensated COVID-19 Two-patient Ventilator Sharing Using the Pulse Physiology Engine." PLOS ONE 15, no. 12 (2020): e0242532. https://doi.org/10.1371/journal.pone.0242532.
- Webb, Jeffrey B., Aaron Bray, and Rachel B. Clipp. "Parameterization of Respiratory Physiology and Pathophysiology for Real-Time Simulation." In 42nd Annual International Conference of the IEEE Engineering in Medicine and Biology Society (EMBC'20), 2020. https://doi.org/10.1109/EMBC44109.2020.9176364.
- Kesavadas, Mrinali, and Pavithra Rajeswaran. "Cyber Physical CPR Training System with Physiological Feedback." In 41st Annual International Conference of the IEEE Engineering in Medicine & Biology Society (EMBC), 2019.
- Bray, Aaron, Jeffrey B. Webb, Andinet Enquobahrie, Jared Vicory, Jerry Heneghan, Robert Hubal, Stephanie TerMaath, Philip Asare, and Rachel B. Clipp. "Pulse Physiology Engine: An Open-Source Software Platform for Computational Modeling of Human Medical Simulation." SN Comprehensive Clinical Medicine 1, no. 2 (2019): 23–34. https://doi.org/10.1007/s42399-019-00053-w.
- Gessa, Farooq M. "Testing and Validation Framework for Closed-Loop Physiology Management Systems for Critical and Perioperative Care." Master's thesis, Bucknell University, 2019. https://digitalcommons.bucknell.edu/masters_theses/220.
- Rodriquez Jr, Dario, Thomas Blakeman, Dina Gomaa, and Richard Branson. "Advancing Mechanical Ventilation Management through Simulation." No. AFRL-SA-WP-SR-2019-0006. USAFSAM/FHE Wright-Patterson AFB United States, 2019. https://apps.dtic.mil/sti/tr/pdf/AD1074448.pdf.
- Webb, Jeffrey B., Rodney Metoyer, Aaron Bray, and Rachel B. Clipp. "Simulation of Asthma Attack and Inhaler Actuation using the Pulse Physiology Engine." Presented at BMES Frontiers in Medical Devices, March 2019.
- Taylor, Glenn, Anthony Deschamps, Alyssa Tanaka, Denise Nicholson, Gerd Bruder, Gregory Welch, and Francisco Guido-Sanz. "Augmented Reality for Tactical Combat Casualty Care Training." In International Conference on Augmented Cognition, edited by Dylan Schmorrow and Cali Fidopiastis, 102–14. Cham: Springer, 2018. https://doi.org/10.1007/978-3-319-91467-1_19.
- Ruales Rosero, Paul, Pavithra Rajeswaran, Jeffrey Webb, Aaron Bray, and Thenkurussi Kesavadas. "Modeling Valvular Diseases Using a Virtual Physiology Engine." In 40th Annual International Conference of the IEEE Engineering in Medicine and Biology Society (EMBC). Honolulu, Hawaii, 2018.
- Gessa, Farooq, Philip Asare, Aaron Bray, Rachel Clipp, and S. Mark Poler. "Towards a Test and Validation Framework for Closed-Loop Physiology Management Systems for Critical and Perioperative Care." Presented at the Medical Cyber Physical Systems Workshop, Porto, Portugal, 2018.
- Gessa, Farooq, Philip Asare, Dikendra Karki, Aaron Bray, Rachel B. Clipp, and Mark Poler. "Simulation-Based Test and Validation of Medical Cyber-Physical Systems for Critical and Perioperative Care." Presented at the Workshop on Monitoring and Testing of Cyber-Physical Systems (MT-CPS).
- Gessa, Farooq, Aaron Bray, Rachel Clipp, Philip Asare, and S. Mark Poler. "A Proof-of-Concept Framework for Testing and Validating Networked Medical Device Applications and Closed-Loop Physiology Management Systems for Critical and Perioperative Care." Presented at the Society for Technology in Anesthesia (STA) Annual Meeting.
- Potter, Lucas, Sreekanth Arikatla, Aaron Bray, Jeff Webb, and Andinet Enquobahrie. "Physiology Informed Virtual Surgical Planning: A Case Study with a Virtual Airway Surgical Planner and BioGears." In SPIE Medical Imaging Conference on Image-Guided Procedures, Robotic Interventions, and Modeling. Orlando, FL, 2017. https://doi.org/10.1117/12.2252510.
- Fisher, Charles E., Randall J. Frank, Chris Argenta, Chris Petrovitch, Eddie Oxford, Jeremy C. Pamplin, William L. Baker Jr, Daniel S. Wendroff, Leopoldo C. Cancio, and Andriy I. Batchinsky. "Forecasting the Trajectory of Blood Loss from Vital Signs Collected at the Bedside: A Principal Component Analysis Approach." Presented at the 15th International Conference on Complex Acute Illness. Pasadena, CA, 2016.
- Metoyer, Rodney, Jenn Carter, Bryan Bergeron, Austin Baird, Aaron Bray, Rachel B. Clipp, M. Cameron Thames, and Jeffrey B. Webb. "A Framework for Multiscale Physiology: Towards Individualized Computer Simulation." Presented at VPH2016, University of Amsterdam, Amsterdam, 2016.
- Clipp, Rachel B., Aaron M. Bray, Rodney Jr. Metoyer, M. Cameron Thames, and Jeffrey B. Webb. "Pharmacokinetic and Pharmacodynamic Modeling in BioGears." In 2016 IEEE Engineering in Medicine and Biology Society (EMBC), 2016. https://doi.org/10.1109/EMBC.2016.7590986.
- Clipp, Rachel B., M. Cameron Thames, Jeffrey B. Webb, Zachary Swarm, Rodney Metoyer, Aaron M. Bray, and Jenn N. Carter. "Integration of a Baroreflex Model into a Whole Body Physiology Engine." Presented at the ASME Summer Biomechanics, BioTransport, and BioEngineering Conference, National Harbor, MD, 2016.
- Clipp, Rachel B., Jeffrey B. Webb, M. Cameron Thames, Zachary Swarm, Rodney Metoyer, and Aaron Bray. "Pharmacokinetic and Pharmacodynamic Modeling in BioGears." Presented at Medicine Meets Virtual Reality Conference, Los Angeles, CA, 2016.
- Metoyer, Rodney, Bryan Bergeron, Rachel B. Clipp, Jeffrey B. Webb, M. Cameron Thames, Zachary Swarm, Jenn Carter, Y. Gebremichael, and Jeremiah Heneghan. "Multiscale Simulation of Insults and Interventions: The BioGears Showcase Scenarios." Presented at Medicine Meets Virtual Reality Conference, Los Angeles, CA, 2016.
- Swarm, Zachary, Jeffrey B. Webb, Rachel B. Clipp, Jenn Carter, M. Cameron Thames, Rodney Metoyer, Aaron Bray, and David Byrd. "Modeling Renal Behavior and Control in BioGears." Presented at Medicine Meets Virtual Reality Conference, Los Angeles, CA, 2016.
- Thames, M. Cameron, Jeffrey B. Webb, Rachel B. Clipp, Jenn Carter, Zachary Swarm, Rodney Metoyer, Aaron Bray, and David Byrd. "Dynamic Response to Heat Gain and Heat Loss in the BioGears Engine." Presented at Medicine Meets Virtual Reality Conference, Los Angeles, CA, 2016.
- Bergeron, Bryan. "BioGears—It's Alive!" Servo Magazine, December 2015. https://www.servomagazine.com/magazine/article/biogears-its-alive.
- Gebremichael, Y., R. Clipp, J. Webb, A. Bray, M. Cameron Thames, Z. Swarm, J. Carter, and J. Heneghan. "Integration of a Spontaneous Respiratory Driver with Blood Gas Feedback into BioGears, an Open-Source, Whole-Body Physiology Model." Presented at the Summer Biomechanics, Bioengineering and Biotransport Conference. Snowbird Resort, Utah, 2015.
- Metoyer, Rodney, and Beth Smith. "Modeling the Time-Dependent Intrapericardial Pressure-Volume Relationship." Presented at the World Congress of Biomechanics, Boston, MA, 2014.
- Kauchak, Marty. "Game Changer." MedSim Magazine 3, no. 2 (2014): 21.
- Clipp, Rachel B., and Gabriel Scott. "HumanSim: A Physiology Engine for the Simulation of Anesthesia/Anaphylaxis." Presented at the Military Health Research Symposium, Fort Lauderdale, FL, 2012.
