/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

#pragma once
#include "cdm/properties/SEScalar.h"

class CDM_DECL VolumePerTimePressureUnit : public CCompoundUnit
{
public:
  VolumePerTimePressureUnit(const std::string& u) : CCompoundUnit(u) {}
  virtual ~VolumePerTimePressureUnit() {}

  // Please use static units below
  VolumePerTimePressureUnit(const VolumePerTimePressureUnit&) = delete;
  VolumePerTimePressureUnit& operator= (const VolumePerTimePressureUnit&) = delete;

  static bool IsValidUnit(const std::string& unit);
  static const VolumePerTimePressureUnit& GetCompoundUnit(const std::string& unit);

  static const VolumePerTimePressureUnit L_Per_s_mmHg;
  static const VolumePerTimePressureUnit mL_Per_s_mmHg;
  static const VolumePerTimePressureUnit L_Per_min_mmHg;
  static const VolumePerTimePressureUnit mL_Per_min_mmHg;
};

class CDM_DECL SEScalarVolumePerTimePressure : public SEScalarQuantity<VolumePerTimePressureUnit>
{
public:
  SEScalarVolumePerTimePressure() {}
  virtual ~SEScalarVolumePerTimePressure() {}
};
