/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utils {
    public static String repeat(String string, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static File prepareFile(String filename) {
        File file = new File(filename);
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return file;
    }

    public static Member getMemberFromDescriptor(String descriptor, ClassLoader ... classLoaders) throws ReflectionsException {
        int p0 = descriptor.indexOf(40);
        String methodKey = descriptor.substring(0, p0);
        String methodParameters = descriptor.substring(p0 + 1, descriptor.length() - 1);
        int p1 = methodKey.lastIndexOf(46);
        String className = methodKey.substring(methodKey.lastIndexOf(32) + 1, p1);
        String methodName = methodKey.substring(p1 + 1);
        Class[] parameterTypes = null;
        if (!Utils.isEmpty(methodParameters)) {
            String[] parameterNames = methodParameters.split(",");
            ArrayList result = new ArrayList(parameterNames.length);
            for (String name : parameterNames) {
                result.add(ReflectionUtils.forName(name.trim(), new ClassLoader[0]));
            }
            parameterTypes = result.toArray(new Class[result.size()]);
        }
        Class<?> aClass = ReflectionUtils.forName(className, classLoaders);
        try {
            if (Utils.isConstructor(descriptor)) {
                return aClass.getConstructor(parameterTypes);
            }
            return aClass.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionsException("Can't resolve method named " + methodName, e);
        }
    }

    public static Set<Method> getMethodsFromDescriptors(Collection<String> annotatedWith, ClassLoader ... classLoaders) {
        HashSet result = Sets.newHashSet();
        for (String annotated : annotatedWith) {
            Method member;
            if (Utils.isConstructor(annotated) || (member = (Method)Utils.getMemberFromDescriptor(annotated, classLoaders)) == null) continue;
            result.add(member);
        }
        return result;
    }

    public static Set<Constructor> getConstructorsFromDescriptors(Collection<String> annotatedWith, ClassLoader ... classLoaders) {
        HashSet result = Sets.newHashSet();
        for (String annotated : annotatedWith) {
            Constructor member;
            if (!Utils.isConstructor(annotated) || (member = (Constructor)Utils.getMemberFromDescriptor(annotated, classLoaders)) == null) continue;
            result.add(member);
        }
        return result;
    }

    public static boolean isConstructor(String fqn) {
        return fqn.contains("init>");
    }

    public static Field getFieldFromString(String field, ClassLoader ... classLoaders) {
        String className = field.substring(0, field.lastIndexOf(46));
        String fieldName = field.substring(field.lastIndexOf(46) + 1);
        try {
            return ReflectionUtils.forName(className, classLoaders).getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionsException("Can't resolve field named " + fieldName, e);
        }
    }

    public static void close(InputStream closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public static Logger findLogger(Class<?> aClass) {
        try {
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return LoggerFactory.getLogger(aClass);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static <T> Set<T> intersect(Collection<T> ts1, Collection<T> ts2) {
        HashSet result = Sets.newHashSet();
        for (T t : ts1) {
            if (!ts2.contains(t)) continue;
            result.add(t);
        }
        return result;
    }
}

