/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFEvaluationCell;
import org.apache.poi.xssf.streaming.SXSSFEvaluationSheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;

public final class SXSSFEvaluationWorkbook
extends BaseXSSFEvaluationWorkbook {
    private SXSSFWorkbook _uBook;

    public static SXSSFEvaluationWorkbook create(SXSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new SXSSFEvaluationWorkbook(book);
    }

    private SXSSFEvaluationWorkbook(SXSSFWorkbook book) {
        super(book.getXSSFWorkbook());
        this._uBook = book;
    }

    public int getSheetIndex(EvaluationSheet evalSheet) {
        SXSSFSheet sheet = ((SXSSFEvaluationSheet)evalSheet).getSXSSFSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    public EvaluationSheet getSheet(int sheetIndex) {
        return new SXSSFEvaluationSheet(this._uBook.getSheetAt(sheetIndex));
    }

    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        SXSSFCell cell = ((SXSSFEvaluationCell)evalCell).getSXSSFCell();
        SXSSFEvaluationWorkbook frBook = SXSSFEvaluationWorkbook.create(this._uBook);
        return FormulaParser.parse((String)cell.getCellFormula(), (FormulaParsingWorkbook)frBook, (int)0, (int)this._uBook.getSheetIndex(cell.getSheet()));
    }
}

