/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.Background;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.FillStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackground;

public class XSLFBackground
extends XSLFSimpleShape
implements Background<XSLFShape, XSLFTextParagraph> {
    XSLFBackground(CTBackground shape, XSLFSheet sheet) {
        super((XmlObject)shape, sheet);
    }

    @Override
    public Rectangle getAnchor() {
        Dimension pg = this.getSheet().getSlideShow().getPageSize();
        return new Rectangle(0, 0, (int)pg.getWidth(), (int)pg.getHeight());
    }

    @Override
    public Color getFillColor() {
        FillStyle fs = this.getFillStyle();
        PaintStyle ps = fs.getPaint();
        if (ps instanceof PaintStyle.SolidPaint) {
            PaintStyle.SolidPaint sp = (PaintStyle.SolidPaint)ps;
            ColorStyle cs = sp.getSolidColor();
            return DrawPaint.applyColorTransform((ColorStyle)cs);
        }
        return null;
    }

    @Override
    protected CTTransform2D getXfrm() {
        return CTTransform2D.Factory.newInstance();
    }
}

