/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.ss.usermodel.Hyperlink;

public class HSSFHyperlink
implements Hyperlink {
    public static final int LINK_URL = 1;
    public static final int LINK_DOCUMENT = 2;
    public static final int LINK_EMAIL = 3;
    public static final int LINK_FILE = 4;
    protected HyperlinkRecord record = null;
    protected int link_type;

    public HSSFHyperlink(int type) {
        this.link_type = type;
        this.record = new HyperlinkRecord();
        switch (type) {
            case 1: 
            case 3: {
                this.record.newUrlLink();
                break;
            }
            case 4: {
                this.record.newFileLink();
                break;
            }
            case 2: {
                this.record.newDocumentLink();
            }
        }
    }

    protected HSSFHyperlink(HyperlinkRecord record) {
        this.record = record;
        this.link_type = record.isFileLink() ? 4 : (record.isDocumentLink() ? 2 : (record.getAddress() != null && record.getAddress().startsWith("mailto:") ? 3 : 1));
    }

    @Override
    public int getFirstRow() {
        return this.record.getFirstRow();
    }

    @Override
    public void setFirstRow(int row) {
        this.record.setFirstRow(row);
    }

    @Override
    public int getLastRow() {
        return this.record.getLastRow();
    }

    @Override
    public void setLastRow(int row) {
        this.record.setLastRow(row);
    }

    @Override
    public int getFirstColumn() {
        return this.record.getFirstColumn();
    }

    @Override
    public void setFirstColumn(int col) {
        this.record.setFirstColumn((short)col);
    }

    @Override
    public int getLastColumn() {
        return this.record.getLastColumn();
    }

    @Override
    public void setLastColumn(int col) {
        this.record.setLastColumn((short)col);
    }

    @Override
    public String getAddress() {
        return this.record.getAddress();
    }

    public String getTextMark() {
        return this.record.getTextMark();
    }

    public void setTextMark(String textMark) {
        this.record.setTextMark(textMark);
    }

    public String getShortFilename() {
        return this.record.getShortFilename();
    }

    public void setShortFilename(String shortFilename) {
        this.record.setShortFilename(shortFilename);
    }

    @Override
    public void setAddress(String address) {
        this.record.setAddress(address);
    }

    @Override
    public String getLabel() {
        return this.record.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.record.setLabel(label);
    }

    @Override
    public int getType() {
        return this.link_type;
    }
}

