﻿/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

using System.Collections.Generic;
using System.IO;
using Pulse;
using Pulse.CDM;

namespace HowTo_RunScenarios
{
  class Example
  {
    public static void Run(string dir = "")
    {

      //{// Test code to ensure we can read everything
      //  DirectoryInfo d = new DirectoryInfo(@"C:\Programming\Pulse\engine\data\human\adult\scenarios\");
      //  FileInfo[] Files = d.GetFiles("*.json", SearchOption.AllDirectories);
      //
      //  foreach (FileInfo file in Files)
      //  {
      //    if (file.Name.Contains("@"))
      //      continue;// This is an assessment
      //    SEScenario sce = new SEScenario();
      //    System.Console.Write("Reading " + file.FullName + "...");
      //    if (!sce.SerializeFromFile(file.FullName))
      //      System.Console.Error.WriteLine("Unable to read scenario file " + file.FullName);
      //    else
      //      System.Console.WriteLine("OK!");
      //  }
      //}

      if (dir.Length == 0)// Run a single hard coded scenario
      {
        // Note, you don't need a RunConfiguration, if you know where your files all are
        // This is a convienance utility for this example to use a scenario from our repository
        // This class informs me where the repository is on your computer (generated by the CMake build)
        RunConfiguration cfg = new RunConfiguration();
        SEScenarioExec execOpts = new SEScenarioExec();
        // Set the directory where Pulse can find its data files (usally bin/install)
        execOpts.SetDataRootDirectory("./");
        // Set empty CSV dir if you do not want a csv file
        execOpts.SetDataRequestCSVFilename("");
        //execOpts.SetDataRequestCSVFilename("./test_results/howto/scenarios/patient/BasicStandardResults.csv");
        execOpts.SetLogFilename("./test_results/howto/scenarios/patient/BasicStandardResults.log");
        execOpts.SetScenarioFilename(cfg.getScenarioDirectory() + "/patient/BasicStandard.json");
        // Where do you want any states created by scenarios to go?
        execOpts.SetSerializationDirectory("./states/");
        PulseEngine pulse = new PulseEngine();
        if (!pulse.ExecuteScenario(execOpts))
          System.Console.Out.WriteLine("Error running scenario");
      }
      else // Assume this is a directory full of scenario json files to run
      {
        string out_dir = dir + "/output/";

        SEScenarioExec opts = new SEScenarioExec();
        opts.SetDataRootDirectory("./");
        opts.SetDataRequestCSVFilename("");

        DirectoryInfo d = new DirectoryInfo(dir);
        FileInfo[] Files = d.GetFiles("*.json");
        foreach (FileInfo file in Files)
        {
          System.Console.Out.WriteLine("\n------------------------------------------------------------\n");
          System.Console.Out.WriteLine("Executing Scenario " + file.FullName);
          string base_name = System.IO.Path.GetFileNameWithoutExtension(file.Name);
          opts.SetLogFilename(out_dir + base_name + ".log");
          opts.SetScenarioFilename(file.FullName);
          opts.SetSerializationDirectory(out_dir);

          PulseEngine pulse = new PulseEngine();
          pulse.LogToConsole(true);
          if (!pulse.ExecuteScenario(opts))
            System.Console.Out.WriteLine("Error running scenario");
        }
      }
    }
  }
}
