/* Distributed under the Apache License, Version 2.0.
   See accompanying NOTICE file for details.*/

package pulse.cdm.system.equipment.inhaler.actions;

import pulse.cdm.bind.InhalerActions.InhalerActionData;

import pulse.cdm.system.equipment.SEEquipmentAction;

public abstract class SEInhalerAction extends SEEquipmentAction
{
  public SEInhalerAction()
  {
    
  }
  
  public void copy(SEInhalerAction other)
  {
    if (this == other)
      return;
    super.copy(other);
  }
  
  public void reset()
  {
    super.reset();
  }
  
  public static void load(InhalerActionData src, SEInhalerAction dst) 
  {
    SEEquipmentAction.load(src.getEquipmentAction(), dst);
  }
  protected static void unload(SEInhalerAction src, InhalerActionData.Builder dst)
  {
    SEEquipmentAction.unload(src, dst.getEquipmentActionBuilder());
  }
  
  public abstract String toString();
}
