Documentation {#Docs}
=====================

Pulse @ref version is available from our <a href="https://gitlab.kitware.com/physiology/engine">GitLab repository</a>.


<b>Implementation</b>

Many of the physiology models in the engine are adapted or implemented directly from models described in literature. 
The implementation methodology is described in detail in the @ref SystemMethodology and sub-system documentation.
All of the source publications are cited in the methodology reports and listed in the <a href="https://gitlab.kitware.com/physiology/engine/blob/master/docs/Sources.bib">Bibliography.</a>


<b>Common Data Model</b>

The Pulse architecture is built around a @ref CDM that defines the key <a href="_c_d_m_tables.html">data structures</a> as well as many implementations of <a href="_c_d_m.html#common-algorithms">common algorithms</a> needed for lumped parameter physiology modeling.


<b>Integration</b>

One instance of a Pulse engine simulates one patient.

Pulse provides a @ref physeng for creation and control of an engine.
This interface provides applications the ability to instantiate, advance time, execute
various actions and retrieve a range of calculated physiological outputs.


<b>Scenarios</b>

Pulse supports a JSON based format for use in writing @ref ScenarioFile.
A ScenarioDriver is provided to run these files and produce a CSV file for plotting data for the duration of the scenario.

<b>Doxygen</b>

The documentation generated on this website was provided in markdown and is generated by doxygen

Doxygen also generates the following resources:
  - <a href="annotated.html">Class Documentation</a>
  - <a href="modules.html">Complete list of cdm structures</a>
  - <a href="pages.html">Index of all Markdown files</a>


<b>More questions?</b>

Visit our @ref FAQ for more information about Pulse
