/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;

public class ObjectIdSerializer {
    public static void write(OutputStream out, @Nullable AnyObjectId id) throws IOException {
        if (id != null) {
            out.write(1);
            id.copyRawTo(out);
        } else {
            out.write(0);
        }
    }

    @Nullable
    public static ObjectId read(InputStream in) throws IOException {
        switch (in.read()) {
            case 0: {
                return null;
            }
            case 1: {
                byte[] b = new byte[20];
                IO.readFully(in, b, 0, 20);
                return ObjectId.fromRaw(b);
            }
        }
        throw new IOException("Invalid flag before ObjectId");
    }

    private ObjectIdSerializer() {
    }
}

