/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.apache.pdfbox.pdmodel.graphics.blend.SoftMaskPaint;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.rendering.CIDType0Glyph2D;
import org.apache.pdfbox.rendering.Glyph2D;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawerParameters;
import org.apache.pdfbox.rendering.TTFGlyph2D;
import org.apache.pdfbox.rendering.TilingPaint;
import org.apache.pdfbox.rendering.Type1Glyph2D;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class PageDrawer
extends PDFGraphicsStreamEngine {
    private static final Log LOG = LogFactory.getLog(PageDrawer.class);
    private final PDFRenderer renderer;
    private Graphics2D graphics;
    private AffineTransform xform;
    private PDRectangle pageSize;
    private int clipWindingRule = -1;
    private GeneralPath linePath = new GeneralPath();
    private Area lastClip;
    private Area textClippingArea;
    private final Map<PDFont, Glyph2D> fontGlyph2D = new HashMap<PDFont, Glyph2D>();

    public PageDrawer(PageDrawerParameters parameters) throws IOException {
        super(parameters.getPage());
        this.renderer = parameters.getRenderer();
    }

    public final PDFRenderer getRenderer() {
        return this.renderer;
    }

    protected final Graphics2D getGraphics() {
        return this.graphics;
    }

    protected final GeneralPath getLinePath() {
        return this.linePath;
    }

    private void setRenderingHints() {
        this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void drawPage(Graphics g, PDRectangle pageSize) throws IOException {
        this.graphics = (Graphics2D)g;
        this.xform = this.graphics.getTransform();
        this.pageSize = pageSize;
        this.setRenderingHints();
        this.graphics.translate(0.0, pageSize.getHeight());
        this.graphics.scale(1.0, -1.0);
        this.graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        this.graphics.translate(-pageSize.getLowerLeftX(), -pageSize.getLowerLeftY());
        this.processPage(this.getPage());
        for (PDAnnotation annotation : this.getPage().getAnnotations()) {
            this.showAnnotation(annotation);
        }
        this.graphics = null;
    }

    void drawTilingPattern(Graphics2D g, PDTilingPattern pattern, PDColorSpace colorSpace, PDColor color, Matrix patternMatrix) throws IOException {
        Graphics2D oldGraphics = this.graphics;
        this.graphics = g;
        GeneralPath oldLinePath = this.linePath;
        this.linePath = new GeneralPath();
        Area oldLastClip = this.lastClip;
        this.lastClip = null;
        this.setRenderingHints();
        this.processTilingPattern(pattern, color, colorSpace, patternMatrix);
        this.graphics = oldGraphics;
        this.linePath = oldLinePath;
        this.lastClip = oldLastClip;
    }

    protected Paint getPaint(PDColor color) throws IOException {
        PDColorSpace colorSpace = color.getColorSpace();
        if (!(colorSpace instanceof PDPattern)) {
            float[] rgb = colorSpace.toRGB(color.getComponents());
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        PDPattern patternSpace = (PDPattern)colorSpace;
        PDAbstractPattern pattern = patternSpace.getPattern(color);
        if (pattern instanceof PDTilingPattern) {
            PDTilingPattern tilingPattern = (PDTilingPattern)pattern;
            if (tilingPattern.getPaintType() == 1) {
                return new TilingPaint(this, tilingPattern, this.xform);
            }
            return new TilingPaint(this, tilingPattern, patternSpace.getUnderlyingColorSpace(), color, this.xform);
        }
        PDShadingPattern shadingPattern = (PDShadingPattern)pattern;
        PDShading shading = shadingPattern.getShading();
        if (shading == null) {
            LOG.error((Object)"shadingPattern is null, will be filled with transparency");
            return new Color(0, 0, 0, 0);
        }
        return shading.toPaint(Matrix.concatenate(this.getInitialMatrix(), shadingPattern.getMatrix()));
    }

    private void setClip() {
        Area clippingPath = this.getGraphicsState().getCurrentClippingPath();
        if (clippingPath != this.lastClip) {
            this.graphics.setClip(clippingPath);
            this.lastClip = clippingPath;
        }
    }

    @Override
    public void beginText() throws IOException {
        this.setClip();
        this.beginTextClip();
    }

    @Override
    public void endText() throws IOException {
        this.endTextClip();
    }

    private void beginTextClip() {
        this.textClippingArea = new Area();
    }

    private void endTextClip() {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        if (renderingMode.isClip() && !this.textClippingArea.isEmpty()) {
            state.intersectClippingPath(this.textClippingArea);
            this.textClippingArea = null;
        }
    }

    @Override
    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        AffineTransform at = textRenderingMatrix.createAffineTransform();
        at.concatenate(font.getFontMatrix().createAffineTransform());
        Glyph2D glyph2D = this.createGlyph2D(font);
        this.drawGlyph2D(glyph2D, font, code, displacement, at);
    }

    private void drawGlyph2D(Glyph2D glyph2D, PDFont font, int code, Vector displacement, AffineTransform at) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        GeneralPath path = glyph2D.getPathForCharacterCode(code);
        if (path != null) {
            float fontWidth;
            if (!font.isEmbedded() && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                float pdfWidth = displacement.getX() * 1000.0f;
                at.scale(pdfWidth / fontWidth, 1.0);
            }
            Shape glyph = at.createTransformedShape(path);
            if (renderingMode.isFill()) {
                this.graphics.setComposite(state.getNonStrokingJavaComposite());
                this.graphics.setPaint(this.getNonStrokingPaint());
                this.setClip();
                this.graphics.fill(glyph);
            }
            if (renderingMode.isStroke()) {
                this.graphics.setComposite(state.getStrokingJavaComposite());
                this.graphics.setPaint(this.getStrokingPaint());
                this.graphics.setStroke(this.getStroke());
                this.setClip();
                this.graphics.draw(glyph);
            }
            if (renderingMode.isClip()) {
                this.textClippingArea.add(new Area(glyph));
            }
        }
    }

    private Glyph2D createGlyph2D(PDFont font) throws IOException {
        Glyph2D glyph2D = this.fontGlyph2D.get(font);
        if (glyph2D != null) {
            return glyph2D;
        }
        if (font instanceof PDTrueTypeFont) {
            PDTrueTypeFont ttfFont = (PDTrueTypeFont)font;
            glyph2D = new TTFGlyph2D(ttfFont);
        } else if (font instanceof PDType1Font) {
            PDType1Font pdType1Font = (PDType1Font)font;
            glyph2D = new Type1Glyph2D(pdType1Font);
        } else if (font instanceof PDType1CFont) {
            PDType1CFont type1CFont = (PDType1CFont)font;
            glyph2D = new Type1Glyph2D(type1CFont);
        } else if (font instanceof PDType0Font) {
            PDType0Font type0Font = (PDType0Font)font;
            if (type0Font.getDescendantFont() instanceof PDCIDFontType2) {
                glyph2D = new TTFGlyph2D(type0Font);
            } else if (type0Font.getDescendantFont() instanceof PDCIDFontType0) {
                PDCIDFontType0 cidType0Font = (PDCIDFontType0)type0Font.getDescendantFont();
                glyph2D = new CIDType0Glyph2D(cidType0Font);
            }
        } else {
            throw new IllegalStateException("Bad font type: " + font.getClass().getSimpleName());
        }
        if (glyph2D != null) {
            this.fontGlyph2D.put(font, glyph2D);
        }
        if (glyph2D == null) {
            throw new UnsupportedOperationException("No font for " + font.getName());
        }
        return glyph2D;
    }

    @Override
    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) {
        this.linePath.moveTo((float)p0.getX(), (float)p0.getY());
        this.linePath.lineTo((float)p1.getX(), (float)p1.getY());
        this.linePath.lineTo((float)p2.getX(), (float)p2.getY());
        this.linePath.lineTo((float)p3.getX(), (float)p3.getY());
        this.linePath.closePath();
    }

    private Raster createSoftMaskRaster(PDSoftMask softMask) throws IOException {
        TransparencyGroup transparencyGroup = new TransparencyGroup(softMask.getGroup(), true);
        COSName subtype = softMask.getSubType();
        if (COSName.ALPHA.equals(subtype)) {
            return transparencyGroup.getAlphaRaster();
        }
        if (COSName.LUMINOSITY.equals(subtype)) {
            return transparencyGroup.getLuminosityRaster();
        }
        throw new IOException("Invalid soft mask subtype.");
    }

    private Paint applySoftMaskToPaint(Paint parentPaint, PDSoftMask softMask) throws IOException {
        if (softMask != null) {
            if (COSName.ALPHA.equals(softMask.getSubType())) {
                LOG.info((Object)"alpha smask not implemented yet, is ignored");
                return parentPaint;
            }
            return new SoftMaskPaint(parentPaint, this.createSoftMaskRaster(softMask));
        }
        return parentPaint;
    }

    private Paint getStrokingPaint() throws IOException {
        return this.applySoftMaskToPaint(this.getPaint(this.getGraphicsState().getStrokingColor()), this.getGraphicsState().getSoftMask());
    }

    private Paint getNonStrokingPaint() throws IOException {
        return this.getPaint(this.getGraphicsState().getNonStrokingColor());
    }

    private BasicStroke getStroke() {
        PDGraphicsState state = this.getGraphicsState();
        float lineWidth = this.transformWidth(state.getLineWidth());
        if ((double)lineWidth < 0.25) {
            lineWidth = 0.25f;
        }
        PDLineDashPattern dashPattern = state.getLineDashPattern();
        int phaseStart = dashPattern.getPhase();
        float[] dashArray = dashPattern.getDashArray();
        if (dashArray != null) {
            for (int i = 0; i < dashArray.length; ++i) {
                float w = this.transformWidth(dashArray[i]);
                if (w == 0.0f) continue;
                dashArray[i] = Math.max(w, 0.016f);
            }
            phaseStart = (int)this.transformWidth(phaseStart);
            if (dashArray.length == 0) {
                dashArray = null;
            }
        }
        return new BasicStroke(lineWidth, state.getLineCap(), state.getLineJoin(), state.getMiterLimit(), dashArray, phaseStart);
    }

    @Override
    public void strokePath() throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getStrokingJavaComposite());
        this.graphics.setPaint(this.getStrokingPaint());
        this.graphics.setStroke(this.getStroke());
        this.setClip();
        this.graphics.draw(this.linePath);
        this.linePath.reset();
    }

    @Override
    public void fillPath(int windingRule) throws IOException {
        boolean noAntiAlias;
        this.graphics.setComposite(this.getGraphicsState().getNonStrokingJavaComposite());
        this.graphics.setPaint(this.getNonStrokingPaint());
        this.setClip();
        this.linePath.setWindingRule(windingRule);
        Rectangle2D bounds = this.linePath.getBounds2D();
        boolean bl = noAntiAlias = this.isRectangular(this.linePath) && bounds.getWidth() > 1.0 && bounds.getHeight() > 1.0;
        if (noAntiAlias) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (!(this.graphics.getPaint() instanceof Color)) {
            Area area = new Area(this.linePath);
            area.intersect(new Area(this.graphics.getClip()));
            this.graphics.fill(area);
        } else {
            this.graphics.fill(this.linePath);
        }
        this.linePath.reset();
        if (noAntiAlias) {
            this.setRenderingHints();
        }
    }

    private boolean isRectangular(GeneralPath path) {
        PathIterator iter = path.getPathIterator(null);
        double[] coords = new double[6];
        int count = 0;
        int[] xs = new int[4];
        int[] ys = new int[4];
        while (!iter.isDone()) {
            switch (iter.currentSegment(coords)) {
                case 0: {
                    if (count != 0) {
                        return false;
                    }
                    xs[count] = (int)Math.floor(coords[0]);
                    ys[count] = (int)Math.floor(coords[1]);
                    ++count;
                    break;
                }
                case 1: {
                    if (count >= 4) {
                        return false;
                    }
                    xs[count] = (int)Math.floor(coords[0]);
                    ys[count] = (int)Math.floor(coords[1]);
                    ++count;
                    break;
                }
                case 3: {
                    return false;
                }
            }
            iter.next();
        }
        if (count == 4) {
            return xs[0] == xs[1] || xs[0] == xs[2] || ys[0] == ys[1] || ys[0] == ys[3];
        }
        return false;
    }

    @Override
    public void fillAndStrokePath(int windingRule) throws IOException {
        GeneralPath path = (GeneralPath)this.linePath.clone();
        this.fillPath(windingRule);
        this.linePath = path;
        this.strokePath();
    }

    @Override
    public void clip(int windingRule) {
        this.clipWindingRule = windingRule;
    }

    @Override
    public void moveTo(float x, float y) {
        this.linePath.moveTo(x, y);
    }

    @Override
    public void lineTo(float x, float y) {
        this.linePath.lineTo(x, y);
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.linePath.curveTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public Point2D getCurrentPoint() {
        return this.linePath.getCurrentPoint();
    }

    @Override
    public void closePath() {
        this.linePath.closePath();
    }

    @Override
    public void endPath() {
        if (this.clipWindingRule != -1) {
            this.linePath.setWindingRule(this.clipWindingRule);
            this.getGraphicsState().intersectClippingPath(this.linePath);
            this.clipWindingRule = -1;
        }
        this.linePath.reset();
    }

    @Override
    public void drawImage(PDImage pdImage) throws IOException {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        if (!pdImage.getInterpolate()) {
            boolean isScaledUp;
            boolean bl = isScaledUp = (long)pdImage.getWidth() < Math.round(at.getScaleX()) || (long)pdImage.getHeight() < Math.round(at.getScaleY());
            if (isScaledUp || pdImage.isStencil()) {
                this.graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
        if (pdImage.isStencil()) {
            BufferedImage image = pdImage.getStencilImage(this.getNonStrokingPaint());
            this.drawBufferedImage(image, at);
        } else {
            this.drawBufferedImage(pdImage.getImage(), at);
        }
        if (!pdImage.getInterpolate()) {
            this.setRenderingHints();
        }
    }

    private void drawBufferedImage(BufferedImage image, AffineTransform at) throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getNonStrokingJavaComposite());
        this.setClip();
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            AffineTransform imageTransform = new AffineTransform(at);
            imageTransform.scale(1.0, -1.0);
            imageTransform.translate(0.0, -1.0);
            Paint awtPaint = new TexturePaint(image, new Rectangle2D.Double(imageTransform.getTranslateX(), imageTransform.getTranslateY(), imageTransform.getScaleX(), imageTransform.getScaleY()));
            awtPaint = this.applySoftMaskToPaint(awtPaint, softMask);
            this.graphics.setPaint(awtPaint);
            Rectangle2D.Float unitRect = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
            this.graphics.fill(at.createTransformedShape(unitRect));
        } else {
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            AffineTransform imageTransform = new AffineTransform(at);
            imageTransform.scale(1.0 / (double)width, -1.0 / (double)height);
            imageTransform.translate(0.0, -height);
            this.graphics.drawImage(image, imageTransform, null);
        }
    }

    @Override
    public void shadingFill(COSName shadingName) throws IOException {
        PDShading shading = this.getResources().getShading(shadingName);
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Paint paint = shading.toPaint(ctm);
        this.graphics.setComposite(this.getGraphicsState().getNonStrokingJavaComposite());
        this.graphics.setPaint(paint);
        this.graphics.setClip(null);
        this.lastClip = null;
        this.graphics.fill(this.getGraphicsState().getCurrentClippingPath());
    }

    @Override
    public void showAnnotation(PDAnnotation annotation) throws IOException {
        this.lastClip = null;
        int deviceType = this.graphics.getDeviceConfiguration().getDevice().getType();
        if (deviceType == 1 && !annotation.isPrinted()) {
            return;
        }
        if (deviceType == 0 && annotation.isNoView()) {
            return;
        }
        if (annotation.isHidden()) {
            return;
        }
        super.showAnnotation(annotation);
        if (annotation.getAppearance() == null) {
            if (annotation instanceof PDAnnotationLink) {
                this.drawAnnotationLinkBorder((PDAnnotationLink)annotation);
            }
            if (annotation instanceof PDAnnotationMarkup && annotation.getSubtype().equals("Ink")) {
                this.drawAnnotationInk((PDAnnotationMarkup)annotation);
            }
        }
    }

    private AnnotationBorder getAnnotationBorder(PDAnnotation annotation, PDBorderStyleDictionary borderStyle) {
        AnnotationBorder ab = new AnnotationBorder();
        COSArray border = annotation.getBorder();
        if (borderStyle == null) {
            COSBase base3;
            if (border.get(2) instanceof COSNumber) {
                ab.width = ((COSNumber)border.getObject(2)).floatValue();
            }
            if (border.size() > 3 && (base3 = border.getObject(3)) instanceof COSArray) {
                AnnotationBorder.access$302(ab, ((COSArray)base3).toFloatArray());
            }
        } else {
            ab.width = borderStyle.getWidth();
            if (borderStyle.getStyle().equals("D")) {
                AnnotationBorder.access$302(ab, borderStyle.getDashStyle().getDashArray());
            }
            if (borderStyle.getStyle().equals("U")) {
                ab.underline = true;
            }
        }
        ab.color = annotation.getColor();
        if (ab.color == null) {
            ab.color = new PDColor(new float[]{0.0f}, (PDColorSpace)PDDeviceGray.INSTANCE);
        }
        if (ab.dashArray != null) {
            boolean allZero = true;
            for (float f : ab.dashArray) {
                if (f == 0.0f) continue;
                allZero = false;
                break;
            }
            if (allZero) {
                AnnotationBorder.access$302(ab, null);
            }
        }
        return ab;
    }

    private void drawAnnotationLinkBorder(PDAnnotationLink link) throws IOException {
        AnnotationBorder ab = this.getAnnotationBorder(link, link.getBorderStyle());
        if (ab.width == 0.0f) {
            return;
        }
        PDRectangle rectangle = link.getRectangle();
        Stroke oldStroke = this.graphics.getStroke();
        this.graphics.setPaint(this.getPaint(ab.color));
        BasicStroke stroke = new BasicStroke(ab.width, 0, 0, 10.0f, ab.dashArray, 0.0f);
        this.graphics.setStroke(stroke);
        this.graphics.setClip(null);
        if (ab.underline) {
            this.graphics.drawLine((int)rectangle.getLowerLeftX(), (int)rectangle.getLowerLeftY(), (int)(rectangle.getLowerLeftX() + rectangle.getWidth()), (int)rectangle.getLowerLeftY());
        } else {
            this.graphics.drawRect((int)rectangle.getLowerLeftX(), (int)rectangle.getLowerLeftY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
        this.graphics.setStroke(oldStroke);
    }

    private void drawAnnotationInk(PDAnnotationMarkup inkAnnotation) throws IOException {
        if (!inkAnnotation.getCOSObject().containsKey(COSName.INKLIST)) {
            return;
        }
        COSBase base = inkAnnotation.getCOSObject().getDictionaryObject(COSName.INKLIST);
        if (!(base instanceof COSArray)) {
            return;
        }
        AnnotationBorder ab = this.getAnnotationBorder(inkAnnotation, inkAnnotation.getBorderStyle());
        if (ab.width == 0.0f) {
            return;
        }
        this.graphics.setPaint(this.getPaint(ab.color));
        Stroke oldStroke = this.graphics.getStroke();
        BasicStroke stroke = new BasicStroke(ab.width, 0, 0, 10.0f, ab.dashArray, 0.0f);
        this.graphics.setStroke(stroke);
        this.graphics.setClip(null);
        COSArray pathsArray = (COSArray)base;
        for (COSBase baseElement : pathsArray.toList()) {
            if (!(baseElement instanceof COSArray)) continue;
            COSArray pathArray = (COSArray)baseElement;
            int nPoints = pathArray.size() / 2;
            GeneralPath path = new GeneralPath();
            for (int i = 0; i < nPoints; ++i) {
                COSBase bx = pathArray.getObject(i * 2);
                COSBase by = pathArray.getObject(i * 2 + 1);
                if (!(bx instanceof COSNumber) || !(by instanceof COSNumber)) continue;
                float x = ((COSNumber)bx).floatValue();
                float y = ((COSNumber)by).floatValue();
                if (i == 0) {
                    path.moveTo(x, y);
                    continue;
                }
                path.lineTo(x, y);
            }
            this.graphics.draw(path);
        }
        this.graphics.setStroke(oldStroke);
    }

    @Override
    public void showTransparencyGroup(PDTransparencyGroup form) throws IOException {
        TransparencyGroup group = new TransparencyGroup(form, false);
        this.graphics.setComposite(this.getGraphicsState().getNonStrokingJavaComposite());
        this.setClip();
        PDRectangle bbox = group.getBBox();
        AffineTransform prev = this.graphics.getTransform();
        float x = bbox.getLowerLeftX();
        float y = this.pageSize.getHeight() - bbox.getLowerLeftY() - bbox.getHeight();
        this.graphics.setTransform(AffineTransform.getTranslateInstance((double)x * this.xform.getScaleX(), (double)y * this.xform.getScaleY()));
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            BufferedImage image = group.getImage();
            Paint awtPaint = new TexturePaint(image, new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(), image.getHeight()));
            awtPaint = this.applySoftMaskToPaint(awtPaint, softMask);
            this.graphics.setPaint(awtPaint);
            this.graphics.fill(new Rectangle2D.Float(0.0f, 0.0f, bbox.getWidth() * (float)this.xform.getScaleX(), bbox.getHeight() * (float)this.xform.getScaleY()));
        } else {
            this.graphics.drawImage(group.getImage(), null, null);
        }
        this.graphics.setTransform(prev);
    }

    private final class TransparencyGroup {
        private final BufferedImage image;
        private final PDRectangle bbox;
        private final int minX;
        private final int minY;
        private final int width;
        private final int height;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TransparencyGroup(PDTransparencyGroup form, boolean isSoftMask) throws IOException {
            Graphics2D g2dOriginal = PageDrawer.this.graphics;
            Area lastClipOriginal = PageDrawer.this.lastClip;
            Matrix ctm = PageDrawer.this.getGraphicsState().getCurrentTransformationMatrix();
            Matrix transform = Matrix.concatenate(ctm, form.getMatrix());
            GeneralPath transformedBox = form.getBBox().transform(transform);
            Area clip = (Area)PageDrawer.this.getGraphicsState().getCurrentClippingPath().clone();
            clip.intersect(new Area(transformedBox));
            Rectangle2D clipRect = clip.getBounds2D();
            this.bbox = new PDRectangle((float)clipRect.getX(), (float)clipRect.getY(), (float)clipRect.getWidth(), (float)clipRect.getHeight());
            Shape deviceClip = PageDrawer.this.xform.createTransformedShape(clip);
            Rectangle2D bounds = deviceClip.getBounds2D();
            this.minX = (int)Math.floor(bounds.getMinX());
            this.minY = (int)Math.floor(bounds.getMinY());
            int maxX = (int)Math.floor(bounds.getMaxX()) + 1;
            int maxY = (int)Math.floor(bounds.getMaxY()) + 1;
            this.width = maxX - this.minX;
            this.height = maxY - this.minY;
            this.image = new BufferedImage(this.width, this.height, 2);
            Graphics2D g = this.image.createGraphics();
            g.translate(0, this.height);
            g.scale(1.0, -1.0);
            g.transform(PageDrawer.this.xform);
            g.translate(-clipRect.getX(), -clipRect.getY());
            PageDrawer.this.graphics = g;
            try {
                if (isSoftMask) {
                    PageDrawer.this.processSoftMask(form);
                } else {
                    PageDrawer.this.processTransparencyGroup(form);
                }
            }
            finally {
                PageDrawer.this.lastClip = lastClipOriginal;
                PageDrawer.this.graphics.dispose();
                PageDrawer.this.graphics = g2dOriginal;
            }
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public PDRectangle getBBox() {
            return this.bbox;
        }

        public Raster getAlphaRaster() {
            return this.image.getAlphaRaster();
        }

        public Raster getLuminosityRaster() {
            BufferedImage gray = new BufferedImage(this.width, this.height, 10);
            Graphics g = gray.getGraphics();
            g.drawImage(this.image, 0, 0, null);
            g.dispose();
            return gray.getRaster();
        }
    }

    private static class AnnotationBorder {
        private float[] dashArray = null;
        private boolean underline = false;
        private float width = 0.0f;
        private PDColor color;

        private AnnotationBorder() {
        }

        static /* synthetic */ float[] access$302(AnnotationBorder x0, float[] x1) {
            x0.dashArray = x1;
            return x1;
        }
    }
}

