/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.io.ScratchFile;

public final class COSOutputStream
extends FilterOutputStream {
    private final List<Filter> filters;
    private final COSDictionary parameters;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    COSOutputStream(List<Filter> filters, COSDictionary parameters, OutputStream output, ScratchFile scratchFile) {
        super(output);
        this.filters = filters;
        this.parameters = parameters;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.buffer.toByteArray());
            this.buffer = new ByteArrayOutputStream();
            this.filters.get(i).encode(input, this.buffer, this.parameters, i);
        }
        this.out.write(this.buffer.toByteArray());
        super.close();
    }
}

