# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.


# This file sets the basic flags for the Verilog language in CMake.
# It also loads the available platform file for the system-compiler
# if it exists.
# It also loads a system - compiler - processor (or target hardware)
# specific file

include(CMakeLanguageInformation)

# some compilers use different extensions (e.g. slang has none)
# so set the extension here first so it can be overridden by the compiler specific file
if(UNIX)
  set(CMAKE_Verilog_OUTPUT_EXTENSION .o)
else()
  set(CMAKE_Verilog_OUTPUT_EXTENSION .obj)
endif()

set(_INCLUDED_FILE 0)

# Load compiler-specific information.
if(CMAKE_Verilog_COMPILER_ID)
  include(Compiler/${CMAKE_Verilog_COMPILER_ID}-Verilog OPTIONAL)
endif()

set(CMAKE_BASE_NAME)
get_filename_component(CMAKE_BASE_NAME "${CMAKE_Verilog_COMPILER}" NAME_WE)

# load a hardware specific file, mostly useful for embedded compilers
if(CMAKE_SYSTEM_PROCESSOR)
  if(CMAKE_Verilog_COMPILER_ID)
    include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_Verilog_COMPILER_ID}-Verilog-${CMAKE_SYSTEM_PROCESSOR} OPTIONAL RESULT_VARIABLE _INCLUDED_FILE)
  endif()
  if (NOT _INCLUDED_FILE)
    include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_BASE_NAME}-${CMAKE_SYSTEM_PROCESSOR} OPTIONAL)
  endif ()
endif()

# load the system- and compiler specific files
if(CMAKE_Verilog_COMPILER_ID)
  include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_Verilog_COMPILER_ID}-Verilog OPTIONAL RESULT_VARIABLE _INCLUDED_FILE)
endif()
if (NOT _INCLUDED_FILE)
  include(Platform/${CMAKE_EFFECTIVE_SYSTEM_NAME}-${CMAKE_BASE_NAME} OPTIONAL
          RESULT_VARIABLE _INCLUDED_FILE)
endif ()

# load any compiler-wrapper specific information
if (CMAKE_Verilog_COMPILER_WRAPPER)
  __cmake_include_compiler_wrapper(Verilog)
endif ()

# We specify the compiler information in the system file for some
# platforms, but this language may not have been enabled when the file
# was first included.  Include it again to get the language info.
# Remove this when all compiler info is removed from system files.
if (NOT _INCLUDED_FILE)
  include(Platform/${CMAKE_SYSTEM_NAME} OPTIONAL)
endif ()

# This should be included before the _INIT variables are
# used to initialize the cache.  Since the rule variables
# have if blocks on them, users can still define them here.
# But, it should still be after the platform file so changes can
# be made to those values.

if(CMAKE_USER_MAKE_RULES_OVERRIDE)
  # Save the full path of the file so try_compile can use it.
  include(${CMAKE_USER_MAKE_RULES_OVERRIDE} RESULT_VARIABLE _override)
  set(CMAKE_USER_MAKE_RULES_OVERRIDE "${_override}")
endif()

if(CMAKE_USER_MAKE_RULES_OVERRIDE_Verilog)
  # Save the full path of the file so try_compile can use it.
  include(${CMAKE_USER_MAKE_RULES_OVERRIDE_Verilog} RESULT_VARIABLE _override)
  set(CMAKE_USER_MAKE_RULES_OVERRIDE_Verilog "${_override}")
endif()


# These are the only types of flags that should be passed to the verilog
# command, if COMPILE_FLAGS is used on a target this will be used
# to filter out any other flags
set(CMAKE_Verilog_FLAG_REGEX "^[-/](D|I)")

if(NOT CMAKE_INCLUDE_FLAG_Verilog)
  set(CMAKE_INCLUDE_FLAG_Verilog "-I ")
endif()

# add the flags to the cache based
# on the initial values computed in the platform/*.cmake files
# use _INIT variables so that this only happens the first time
# and you can set these flags in the cmake cache
set(CMAKE_Verilog_FLAGS_INIT "$ENV{VCFLAGS} ${CMAKE_Verilog_FLAGS_INIT}")

cmake_initialize_per_config_variable(CMAKE_Verilog_FLAGS "Flags used by the Verilog compiler")

# TODO- This would be for back-end (possible frontend if linked) compile flows to identify the standard libraries
# I.e. all the io_pads, memories, and standard cells definitions.
if(CMAKE_Verilog_STANDARD_LIBRARIES_INIT)
  set(CMAKE_Verilog_STANDARD_LIBRARIES "${CMAKE_Verilog_STANDARD_LIBRARIES_INIT}"
    CACHE STRING "Libraries linked by default with all Verilog applications.")
  mark_as_advanced(CMAKE_Verilog_STANDARD_LIBRARIES)
endif()

# TODO - Don't know what this would be used for for Verilog.
# if(NOT CMAKE_Verilog_COMPILER_LAUNCHER AND DEFINED ENV{CMAKE_Verilog_COMPILER_LAUNCHER})
#   set(CMAKE_Verilog_COMPILER_LAUNCHER "$ENV{CMAKE_Verilog_COMPILER_LAUNCHER}"
#     CACHE STRING "Compiler launcher for Verilog.")
# endif()

# if(NOT CMAKE_Verilog_LINKER_LAUNCHER AND DEFINED ENV{CMAKE_Verilog_LINKER_LAUNCHER})
#   set(CMAKE_Verilog_LINKER_LAUNCHER "$ENV{CMAKE_Verilog_LINKER_LAUNCHER}"
#     CACHE STRING "Linker launcher for Verilog.")
# endif()

include(CMakeCommonLanguageInclude)

# now define the following rules:
# TODO: ? CMAKE_Verilog_CREATE_SHARED_LIBRARY
# TODO: ? CMAKE_Verilog_CREATE_SHARED_MODULE
# CMAKE_Verilog_COMPILE_OBJECT
# TODO: ? CMAKE_Verilog_LINK_EXECUTABLE

# variables supplied by the generator at use time
# <TARGET>
# <TARGET_BASE> the target without the suffix
# <OBJECTS>
# <OBJECT>
# <LINK_LIBRARIES>
# <FLAGS>
# <LINK_FLAGS>

# Verilog compiler information
# <CMAKE_Verilog_COMPILER>
# TBD: ? <CMAKE_SHARED_LIBRARY_CREATE_Verilog_FLAGS>
# TBD: ? <CMAKE_Verilog_SHARED_MODULE_CREATE_FLAGS>
# TBD: ? <CMAKE_Verilog_LINK_FLAGS>

# Static library tools
# TBD: ? <CMAKE_AR>
# TBD: ? <CMAKE_RANLIB>

# This file sets the basic flags for the Verilog compiler
if(NOT CMAKE_Verilog_COMPILE_OBJECT)
  # This is mimic'ed after slang version.
  set(CMAKE_Verilog_COMPILE_OBJECT "<CMAKE_Verilog_COMPILER> <DEFINES> <INCLUDES> <FLAGS> <SOURCE>")
endif()

mark_as_advanced(
CMAKE_VERBOSE_MAKEFILE
)

set(CMAKE_Verilog_INFORMATION_LOADED 1)
