# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.

#TODO- remove next line once figure out a consistent way to test compilers.
set(CMAKE_Verilog_COMPILER_FORCED TRUE)

if(CMAKE_Verilog_COMPILER_FORCED)
  # The compiler configuration was forced by the user.
  # Assume the user has configured all compiler information.
  set(CMAKE_Verilog_COMPILER_WORKS TRUE)
  return()
endif()

include(CMakeTestCompilerCommon)

# Remove any cached result from an older CMake version.
# We now store this in CMakeCCompiler.cmake.
unset(CMAKE_Verilog_COMPILER_WORKS CACHE)

# This file is used by EnableLanguage in cmGlobalGenerator to
# determine that that selected Verilog compiler can actually compile
# and link the most basic of programs.   If not, a fatal error
# is set and cmake stops processing commands and will not generate
# any makefiles or projects.
if(NOT CMAKE_Verilog_COMPILER_WORKS)
  PrintTestCompilerStatus("Verilog")
  __TestCompiler_setTryCompileTargetType()
  string(CONCAT __TestCompiler_testVerilogCompilerSource
   "module test\n"
   "\n"
   "initial begin\n"
   "  \$display (\"The CMAKE_Verilog_COMPILER ran\"\n"
   "end\n"
   "endmodule\n")
  # Clear result from normal variable.
  unset(CMAKE_Verilog_COMPILER_WORKS)
  # Puts test result in cache variable.
  try_compile(CMAKE_Verilog_COMPILER_WORKS
    SOURCE_FROM_VAR testVerilogCompiler.c __TestCompiler_testVerilogCompilerSource
    OUTPUT_VARIABLE __CMAKE_Verilog_COMPILER_OUTPUT)
  unset(__TestCompiler_testVerilogCompilerSource)
  # Move result from cache to normal variable.
  set(CMAKE_Verilog_COMPILER_WORKS ${CMAKE_Verilog_COMPILER_WORKS})
  unset(CMAKE_Verilog_COMPILER_WORKS CACHE)
  __TestCompiler_restoreTryCompileTargetType()
  if(NOT CMAKE_Verilog_COMPILER_WORKS)
    PrintTestCompilerResult(CHECK_FAIL "broken")
    string(REPLACE "\n" "\n  " _output "${__CMAKE_Verilog_COMPILER_OUTPUT}")
    message(FATAL_ERROR "The Verilog compiler\n  \"${CMAKE_Verilog_COMPILER}\"\n"
      "is not able to compile a simple test program.\nIt fails "
      "with the following output:\n  ${_output}\n\n"
      "CMake will not be able to correctly generate this project.")
  endif()
  PrintTestCompilerResult(CHECK_PASS "works")
endif()

# Try to identify the compiler features
include(${CMAKE_ROOT}/Modules/CMakeDetermineCompileFeatures.cmake)
CMAKE_DETERMINE_COMPILE_FEATURES(Verilog)

# Re-configure to save learned information.
configure_file(
  ${CMAKE_ROOT}/Modules/CMakeVerilogCompiler.cmake.in
  ${CMAKE_PLATFORM_INFO_DIR}/CMakeVerilogCompiler.cmake
  @ONLY
  )
include(${CMAKE_PLATFORM_INFO_DIR}/CMakeVerilogCompiler.cmake)

set(CMAKE_TRY_COMPILE_TARGET_TYPE ${__CMAKE_SAVED_TRY_COMPILE_TARGET_TYPE})
unset(__CMAKE_SAVED_TRY_COMPILE_TARGET_TYPE)
unset(__CMAKE_Verilog_COMPILER_OUTPUT)
