# Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
# file Copyright.txt or https://cmake.org/licensing for details.


# determine the compiler to use for Verilog code
# NOTE, a generator may set CMAKE_Verilog_COMPILER before
# loading this file to force a compiler.
# use environment variable VC first if defined by user, next use
# the cmake variable CMAKE_GENERATOR_VC which can be defined by a generator
# as a default compiler
#
# Sets the following variables:
#   CMAKE_Verilog_COMPILER
#

include(${CMAKE_ROOT}/Modules/CMakeDetermineCompiler.cmake)

# Load system-specific compiler preferences for this language.
# Currently no platform specific preferences for Verilog
#include(Platform/${CMAKE_SYSTEM_NAME}-Determine-Verilog OPTIONAL)
#include(Platform/${CMAKE_SYSTEM_NAME}-Verilog OPTIONAL)
if(NOT CMAKE_Verilog_COMPILER_NAMES)
  set(CMAKE_Verilog_COMPILER_NAMES slang)
endif()

# Only support make and ninja generators
# Only support make and ninja generators
if( NOT ( ("${CMAKE_GENERATOR}" MATCHES "Make") OR
          ("${CMAKE_GENERATOR}" MATCHES "Ninja") ) )
  message(FATAL_ERROR "Verilog language not currently supported by \"${CMAKE_GENERATOR}\" generator")
endif()


if(NOT CMAKE_Verilog_COMPILER)
  set(CMAKE_Verilog_COMPILER_INIT NOTFOUND)

  # prefer the environment variable VC
  if(NOT $ENV{VC} STREQUAL "")
    get_filename_component(CMAKE_Verilog_COMPILER_INIT $ENV{VC} PROGRAM PROGRAM_ARGS CMAKE_Verilog_FLAGS_ENV_INIT)
    if(CMAKE_Verilog_FLAGS_ENV_INIT)
      set(CMAKE_Verilog_COMPILER_ARG1 "${CMAKE_Verilog_FLAGS_ENV_INIT}" CACHE STRING "Arguments to Verilog compiler")
    endif()
    if(NOT EXISTS ${CMAKE_Verilog_COMPILER_INIT})
      message(FATAL_ERROR "Could not find compiler set in environment variable VC:\n$ENV{VC}.\n${CMAKE_Verilog_COMPILER_INIT}")
    endif()
  endif()

  # next prefer the generator specified compiler
  if(CMAKE_GENERATOR_Verilog)
    if(NOT CMAKE_Verilog_COMPILER_INIT)
      set(CMAKE_Verilog_COMPILER_INIT ${CMAKE_GENERATOR_Verilog})
    endif()
  endif()

  # finally list compilers to try
  if(NOT CMAKE_Verilog_COMPILER_INIT)
    set(_Verilog_COMPILER_NAMES_Slang    slang)          # SLang OpenSource tools
    set(_Verilog_COMPILER_NAMES_Veripool verilator)      # Veripool OpenSource tools
    set(_Verilog_COMPILER_NAMES_Icarus   iverilog)       # Icarus OpenSource tools
    set(_Verilog_COMPILER_NAMES_Cadence  irun ncverilog) # Cadence EDA Commercial tools
    set(_Verilog_COMPILER_NAMES_Synopsys vcs)            # Synopsys EDA Commercial tools
    set(_Verilog_COMPILER_NAMES_Siemens  modelsim qsim)  # Siemens (Mentor) EDA Commercial tools

    unset(CMAKE_Verilog_COMPILER_LIST)
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Slang})
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Veripool})
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Icarus})
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Cadence})
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Synopsys})
    list(APPEND CMAKE_Verilog_COMPILER_LIST ${_Verilog_COMPILER_NAMES_Siemens})
  endif()

  _cmake_find_compiler(Verilog)
else()
  _cmake_find_compiler_path(Verilog)
endif()
mark_as_advanced(CMAKE_Verilog_COMPILER)

# # Each entry in this list is a set of extra flags to try
# # adding to the compile line to see if it helps produce
# # a valid identification file.
# set(CMAKE_Verilog_COMPILER_ID_TEST_FLAGS_FIRST)
# set(CMAKE_Verilog_COMPILER_ID_TEST_FLAGS
#     #TODO
#     )
# endif()

# if(CMAKE_Verilog_COMPILER_TARGET)
#   set(CMAKE_Verilog_COMPILER_ID_TEST_FLAGS_FIRST "-c --target=${CMAKE_Verilog_COMPILER_TARGET}")
# endif()

# Build a small source file to identify the compiler and usage
if(NOT CMAKE_Verilog_COMPILER_ID_RUN)
  set(CMAKE_Verilog_COMPILER_ID_RUN 1)

  # Try to identify the compiler.
  set(CMAKE_Verilog_COMPILER_ID)
  set(CMAKE_Verilog_PLATFORM_ID)

  # TODO: How to do this for verilog? Right now just basing on the name of the executable.
  # file(READ ${CMAKE_ROOT}/Modules/CMakePlatformId.h.in
  #   CMAKE_Verilog_COMPILER_ID_PLATFORM_CONTENT)

  # include(${CMAKE_ROOT}/Modules/CMakeDetermineCompilerId.cmake)
  # CMAKE_DETERMINE_COMPILER_ID(Verilog VerilogFLAGS CMakeVerilogCompilerId.v)

  # _cmake_find_compiler_sysroot(Verilog)

  get_filename_component(_CMAKE_Verilog_COMPILER_NAME_WE ${CMAKE_Verilog_COMPILER} NAME_WE)
  if(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Slang )
    set(CMAKE_Verilog_COMPILER_ID SLang )
  elseif(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Veripool)
    set(CMAKE_Verilog_COMPILER_ID Veripool )
  elseif(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Icarus)
    set(CMAKE_Verilog_COMPILER_ID Icarus )
  elseif(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Cadence)
    set(CMAKE_Verilog_COMPILER_ID Cadence )
  elseif(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Synopsys)
    set(CMAKE_Verilog_COMPILER_ID Synopsys )
  elseif(_CMAKE_Verilog_COMPILER_NAME_WE IN_LIST _Verilog_COMPILER_NAMES_Siemens)
    set(CMAKE_Verilog_COMPILER_ID Siemens )
  endif()
else()
  # Not variation right now. Might need something here later for FRONTENT_VARIANT
endif()

if (NOT _CMAKE_TOOLCHAIN_LOCATION)
  get_filename_component(_CMAKE_TOOLCHAIN_LOCATION "${CMAKE_Verilog_COMPILER}" PATH)
endif ()

# TODO: may need later for a set of utilities for each vendor?
# set(_CMAKE_PROCESSING_LANGUAGE "Verilog")
# include(CMakeFindBinUtils)
# include(Compiler/${CMAKE_Verilog_COMPILER_ID}-FindBinUtils OPTIONAL)
# unset(_CMAKE_PROCESSING_LANGUAGE)

# configure all variables set in this file
configure_file(${CMAKE_CURRENT_LIST_DIR}/CMakeVerilogCompiler.cmake.in
  ${CMAKE_PLATFORM_INFO_DIR}/CMakeVerilogCompiler.cmake
  )

set(CMAKE_Verilog_COMPILER_ENV_VAR "VC")
