
include ("${RunCMake_SOURCE_DIR}/check_errors.cmake")
unset (errors)

set (path "a/b/c.e.f")
cmake_path (REPLACE_EXTENSION path ".x")
if (NOT path STREQUAL "a/b/c.x")
  list (APPEND errors "'${path}' instead of 'a/b/c.x'")
endif()
cmake_path (REPLACE_EXTENSION path ".y")
if (NOT path STREQUAL "a/b/c.y")
  list (APPEND errors "'${path}' instead of 'a/b/c.y'")
endif()
cmake_path (REPLACE_EXTENSION path "")
if (NOT path STREQUAL "a/b/c")
  list (APPEND errors "'${path}' instead of 'a/b/c'")
endif()

set (path "a/b/c.e.f")
cmake_path (REPLACE_EXTENSION path ".x" LAST_ONLY)
if (NOT path STREQUAL "a/b/c.e.x")
  list (APPEND errors "'${path}' instead of 'a/b/c.e.x'")
endif()
cmake_path (REPLACE_EXTENSION path ".y" LAST_ONLY)
if (NOT path STREQUAL "a/b/c.e.y")
  list (APPEND errors "'${path}' instead of 'a/b/c.e.y'")
endif()
cmake_path (REPLACE_EXTENSION path "" LAST_ONLY)
if (NOT path STREQUAL "a/b/c.e")
  list (APPEND errors "'${path}' instead of 'a/b/c.e'")
endif()

set (path "/a/.b")
cmake_path (REPLACE_EXTENSION path ".x")
if (NOT path STREQUAL "/a/.b.x")
  list (APPEND errors "'${path}' instead of '/a/.b.x'")
endif()
cmake_path (REPLACE_EXTENSION path ".x" LAST_ONLY)
if (NOT path STREQUAL "/a/.b.x")
  list (APPEND errors "'${path}' instead of '/a/.b.x'")
endif()

set (path "/a/b")
cmake_path (REPLACE_EXTENSION path ".x")
if (NOT path STREQUAL "/a/b.x")
  list (APPEND errors "'${path}' instead of '/a/b.x'")
endif()

set (path "/a/b/")
cmake_path (REPLACE_EXTENSION path ".x" OUTPUT_VARIABLE output)
if (NOT path STREQUAL "/a/b/")
  list (APPEND errors "input changed unexpectedly")
endif()
if (NOT output STREQUAL "/a/b/.x")
  list (APPEND errors "'${output}' instead of '/a/b/.x'")
endif()

check_errors (REPLACE_EXTENSION ${errors})
