# - Use Module for QT4
# Sets up C and C++ to use Qt 4.  It is assumed that FindQt.cmake
# has already been loaded.  See FindQt.cmake for information on
# how to load Qt 4 into your CMake project.


ADD_DEFINITIONS(${QT_DEFINITIONS})

INCLUDE_DIRECTORIES(${QT_INCLUDE_DIR})

SET(QT_LIBRARIES "")

IF (QT_USE_QTMAIN)
  IF (WIN32)
    SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_QTMAIN_LIBRARY})
  ENDIF (WIN32)
ENDIF (QT_USE_QTMAIN)

# Macro for setting up compile flags for Qt modules
MACRO(QT_MODULE_SETUP module)
  IF (QT_QT${module}_FOUND)
    ADD_DEFINITIONS(-DQT_${module}_LIB)
    INCLUDE_DIRECTORIES(${QT_QT${module}_INCLUDE_DIR})
    SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_QT${module}_LIBRARY})
    SET(QT_LIBRARIES ${QT_LIBRARIES} ${QT_${module}_LIB_DEPENDENCIES})
  ELSE (QT_QT${module}_FOUND)
    MESSAGE("Qt ${module} library not found.")
  ENDIF (QT_QT${module}_FOUND)
ENDMACRO(QT_MODULE_SETUP)


# Qt modules  (in order of dependence)

IF (QT_USE_QT3SUPPORT)
  QT_MODULE_SETUP(3SUPPORT)
ENDIF (QT_USE_QT3SUPPORT)

IF (QT_USE_QTOPENGL)
  QT_MODULE_SETUP(OPENGL)
ENDIF (QT_USE_QTOPENGL)

IF (QT_USE_QTASSISTANT)
  QT_MODULE_SETUP(ASSISTANT)
ENDIF (QT_USE_QTASSISTANT)

IF (QT_USE_QTDESIGNER)
  QT_MODULE_SETUP(DESIGNER)
ENDIF (QT_USE_QTDESIGNER)

IF (QT_USE_QTMOTIF)
  QT_MODULE_SETUP(MOTIF)
ENDIF (QT_USE_QTMOTIF)

IF (QT_USE_QTNSPLUGIN)
  QT_MODULE_SETUP(NSPLUGIN)
ENDIF (QT_USE_QTNSPLUGIN)

IF (QT_USE_QTSVG)
  QT_MODULE_SETUP(SVG)
ENDIF (QT_USE_QTSVG)

IF (QT_USE_QTUITOOLS)
  QT_MODULE_SETUP(UITOOLS)
ENDIF (QT_USE_QTUITOOLS)

IF (NOT QT_DONT_USE_QTGUI)
  QT_MODULE_SETUP(GUI)
ENDIF (NOT QT_DONT_USE_QTGUI)

IF (QT_USE_QTTEST)
  QT_MODULE_SETUP(TEST)
ENDIF (QT_USE_QTTEST)

IF (QT_USE_QTXML)
  QT_MODULE_SETUP(XML)
ENDIF (QT_USE_QTXML)

IF (QT_USE_QTSQL)
  QT_MODULE_SETUP(SQL)
ENDIF (QT_USE_QTSQL)

IF (QT_USE_QTNETWORK)
  QT_MODULE_SETUP(NETWORK)
ENDIF (QT_USE_QTNETWORK)

IF (NOT QT_DONT_USE_QTCORE)
  QT_MODULE_SETUP(CORE)
ENDIF (NOT QT_DONT_USE_QTCORE)


