
#=============================================================================
# Copyright 2004-2009 Kitware, Inc.
#
# Distributed under the OSI-approved BSD License (the "License");
# see accompanying file Copyright.txt for details.
#
# This software is distributed WITHOUT ANY WARRANTY; without even the
# implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the License for more information.
#=============================================================================
# (To distribute this file outside of CMake, substitute the full
#  License text for the above reference.)

# determine the compiler to use for C programs
# NOTE, a generator may set CMAKE_C_COMPILER before
# loading this file to force a compiler.
# use environment variable CCC first if defined by user, next use
# the cmake variable CMAKE_GENERATOR_CC which can be defined by a generator
# as a default compiler
if(NOT CMAKE_RC_COMPILER)
  # prefer the environment variable CC
  if($ENV{RC} MATCHES ".+")
    get_filename_component(CMAKE_RC_COMPILER_INIT $ENV{RC} PROGRAM PROGRAM_ARGS CMAKE_RC_FLAGS_ENV_INIT)
    if(CMAKE_RC_FLAGS_ENV_INIT)
      set(CMAKE_RC_COMPILER_ARG1 "${CMAKE_RC_FLAGS_ENV_INIT}" CACHE STRING "First argument to RC compiler")
    endif(CMAKE_RC_FLAGS_ENV_INIT)
    if(EXISTS ${CMAKE_RC_COMPILER_INIT})
    else(EXISTS ${CMAKE_RC_COMPILER_INIT})
      message(FATAL_ERROR "Could not find compiler set in environment variable RC:\n$ENV{RC}.")
    endif(EXISTS ${CMAKE_RC_COMPILER_INIT})
  endif($ENV{RC} MATCHES ".+")

  # next try prefer the compiler specified by the generator
  if(CMAKE_GENERATOR_RC)
    if(NOT CMAKE_RC_COMPILER_INIT)
      set(CMAKE_RC_COMPILER_INIT ${CMAKE_GENERATOR_RC})
    endif(NOT CMAKE_RC_COMPILER_INIT)
  endif(CMAKE_GENERATOR_RC)

  # finally list compilers to try
  if(CMAKE_RC_COMPILER_INIT)
    set(CMAKE_RC_COMPILER_LIST ${CMAKE_RC_COMPILER_INIT})
  else(CMAKE_RC_COMPILER_INIT)
    set(CMAKE_RC_COMPILER_LIST rc)
  endif(CMAKE_RC_COMPILER_INIT)

  # Find the compiler.
  find_program(CMAKE_RC_COMPILER NAMES ${CMAKE_RC_COMPILER_LIST} DOC "RC compiler")
  if(CMAKE_RC_COMPILER_INIT AND NOT CMAKE_RC_COMPILER)
    set(CMAKE_RC_COMPILER "${CMAKE_RC_COMPILER_INIT}" CACHE FILEPATH "RC compiler" FORCE)
  endif(CMAKE_RC_COMPILER_INIT AND NOT CMAKE_RC_COMPILER)
endif(NOT CMAKE_RC_COMPILER)

mark_as_advanced(CMAKE_RC_COMPILER)

get_filename_component(_CMAKE_RC_COMPILER_NAME_WE ${CMAKE_RC_COMPILER} NAME_WE)
if(_CMAKE_RC_COMPILER_NAME_WE STREQUAL "windres")
  set(CMAKE_RC_OUTPUT_EXTENSION .obj)
else()
  set(CMAKE_RC_OUTPUT_EXTENSION .res)
endif()

# configure variables set in this file for fast reload later on
configure_file(${CMAKE_ROOT}/Modules/CMakeRCCompiler.cmake.in
               ${CMAKE_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/CMakeRCCompiler.cmake IMMEDIATE)
set(CMAKE_RC_COMPILER_ENV_VAR "RC")
