/*==============================================================================

  Program: 3D Slicer

  Portions (c) Copyright Brigham and Women's Hospital (BWH) All Rights Reserved.

  See COPYRIGHT.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

==============================================================================*/

#ifndef __qSlicerQueryPETCTDicomTagsModuleWidget_h
#define __qSlicerQueryPETCTDicomTagsModuleWidget_h

// SlicerQt includes
#include "qSlicerAbstractModuleWidget.h"

#include "qSlicerQueryPETCTDicomTagsModuleExport.h"

class qSlicerQueryPETCTDicomTagsModuleWidgetPrivate;
class vtkMRMLNode;
class PETDICOMReader;

/// \ingroup Slicer_QtModules_ExtensionTemplate
class Q_SLICER_QTMODULES_QUERYPETCTDICOMTAGS_EXPORT qSlicerQueryPETCTDicomTagsModuleWidget :
  public qSlicerAbstractModuleWidget
{
  Q_OBJECT

public:

  typedef qSlicerAbstractModuleWidget Superclass;
  qSlicerQueryPETCTDicomTagsModuleWidget(QWidget *parent=0);
  virtual ~qSlicerQueryPETCTDicomTagsModuleWidget();

public slots:
	bool loadPETCTFile(const QString &);
	bool updateDICOMTags();


protected:
  QScopedPointer<qSlicerQueryPETCTDicomTagsModuleWidgetPrivate> d_ptr;
  
  virtual void setup();

private:
  Q_DECLARE_PRIVATE(qSlicerQueryPETCTDicomTagsModuleWidget);
  Q_DISABLE_COPY(qSlicerQueryPETCTDicomTagsModuleWidget);
  PETDICOMReader *m_pPETDicomReader;
  void clearAllValues();
};

#endif
