/*==============================================================================

  Program: 3D Slicer

  Copyright (c) Kitware Inc.

  See COPYRIGHT.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  This file was originally developed by Jean-Christophe Fillion-Robin, Kitware Inc.
  and was partially funded by NIH grant 3P41RR013218-12S1

==============================================================================*/

#ifndef __qSlicerQueryPETCTDicomTagsFooBarWidget_h
#define __qSlicerQueryPETCTDicomTagsFooBarWidget_h

// Qt includes
#include <QWidget>

// FooBar Widgets includes
#include "qSlicerQueryPETCTDicomTagsModuleWidgetsExport.h"

class qSlicerQueryPETCTDicomTagsFooBarWidgetPrivate;

/// \ingroup Slicer_QtModules_QueryPETCTDicomTags
class Q_SLICER_MODULE_QUERYPETCTDICOMTAGS_WIDGETS_EXPORT qSlicerQueryPETCTDicomTagsFooBarWidget
  : public QWidget
{
  Q_OBJECT
public:
  typedef QWidget Superclass;
  qSlicerQueryPETCTDicomTagsFooBarWidget(QWidget *parent=0);
  virtual ~qSlicerQueryPETCTDicomTagsFooBarWidget();

protected slots:

protected:
  QScopedPointer<qSlicerQueryPETCTDicomTagsFooBarWidgetPrivate> d_ptr;

private:
  Q_DECLARE_PRIVATE(qSlicerQueryPETCTDicomTagsFooBarWidget);
  Q_DISABLE_COPY(qSlicerQueryPETCTDicomTagsFooBarWidget);
};

#endif
