# 9.0.2

VTK 9.0.2 collects fixes to 9.0.1 which have been made since its release. Of
particular interest are the fixes to macOS rendering, support for the macOS
arm64 platform, and updates for API changes in external libraries.

# New classes

  - Added a `vtkImageProbeFilter` which works like `vtkProbeFilter`, but for
    `vtkImageData`

# New support

  - `enum class` setters and getters are now supported via
    `vtk{Get,Set}EnumMacro`

# Fixes

  - The `QVTKRenderWidget.h` is now installed.
  - `vtk3DLinearGridPlaneCutter` guards against `nullptr` points and cells
  - The composite date mapper now iterates over data blocks properly
  - `vtkStringArray::Resize` takes tuple elements into account
  - `vtkArrowSource` now supports scalong and rotation around the origin or the
    arrow's center point
  - The `VTK::DomainsChemistryOpenGL2`, `VTK::RenderingContextOpenGL2`, and
    `VTK::RenderingOpenGL2` modules are added to the `Rendering` group to avoid
    missing implementations of rendering components
  - `vtkCutter` enables point merging when requested through a
    `vtkPointLocator` which merges points
  - `vtkAxesActor` bounds calculations improved to avoid assumptions about
    range values
  - `vtkWindowLevelLookupTable` out-of-range colors are now initialized
    properly
  - `vtkImageReslice::RequestInformation` is refactored handle common image
    information passing
  - `vtkImageReslice` creates a new interpolator in `::GetInterpolator`; this
    new interpolator now uses the same interpolation mode as `vtkImageReslice`
    itself

## macOS

  - macOS wheels are now built and uploaded by VTK's CI
  - Fixes for macOS OpenGL state tracking (related to `GL_SCISSOR`)
  - Multisampling on macOS with Intel graphics turned off for volume rendering
  - OpenGL state tracking on macOS with layers is improved (rather than using
    the wrong context between layers)
  - OSPRay is disabled when running under macOS Rosetta

## Third Party

  - HDF5 has been updated to address errors on newer Xcode compilers
  - HDF5 macOS universal2 compilation fixes
  - `VTK::mpi` now disables C++ bindings for SGI MPT as well
  - Usage of `numpy.character` is removed (deprecated in NumPy 1.19)
  - Avoidance of APIs deprecated in Python 3.9
  - Compilation with newer libfreetype resolved (`FT_CALLBACK_DEF` usage
    removed)
