set(libjpegturbo_enable_static ON)
if (BUILD_SHARED_LIBS)
  set(libjpegturbo_enable_static OFF)
endif ()

superbuild_add_project(libjpegturbo
  LICENSE_FILES
    LICENSE.md
    README.ijg
  SPDX_LICENSE_IDENTIFIER
    "IJG AND BSD-3-Clause AND Zlib"
  SPDX_COPYRIGHT_TEXT
    "Copyright (C)2009-2023 D. R. Commander"
    "Copyright (C)2015 Viktor Szathmáry"
  CMAKE_ARGS
    -DENABLE_SHARED:BOOL=${BUILD_SHARED_LIBS}
    -DENABLE_STATIC:BOOL=${libjpegturbo_enable_static}
    -DBUILD_TESTING:BOOL=OFF
    -DCMAKE_INSTALL_NAME_DIR:PATH=<INSTALL_DIR>/lib
    -DWITH_SIMD:BOOL=OFF
    -DWITH_CRT_DLL:BOOL=ON
    -DCMAKE_INSTALL_LIBDIR:STRING=lib)

if (WIN32)
  superbuild_apply_patch(libjpegturbo msvc-default-lib-flags
    "remove problematic default flags for MSVC")
endif ()
