if (BUILD_SHARED_LIBS)
  set(ffmpeg_shared_args --enable-shared --disable-static)
else ()
  set(ffmpeg_shared_args --disable-shared --enable-static)
endif ()

set(ffmpeg_c_flags "${superbuild_c_flags}")
if (APPLE AND CMAKE_OSX_SYSROOT)
  string(APPEND ffmpeg_c_flags " --sysroot=${CMAKE_OSX_SYSROOT}")
endif ()
set(ffmpeg_ld_flags "${superbuild_ld_flags}")
if (APPLE AND CMAKE_OSX_DEPLOYMENT_TARGET)
  string(APPEND ffmpeg_ld_flags " -isysroot ${CMAKE_OSX_SYSROOT} -mmacosx-version-min=${CMAKE_OSX_DEPLOYMENT_TARGET}")
endif ()
if (UNIX AND NOT APPLE)
  string(APPEND ffmpeg_ld_flags " -Wl,-rpath,<INSTALL_DIR>/lib")
endif ()

superbuild_add_project(ffmpeg
  DEPENDS zlib pkgconf
  LICENSE_FILES
    LICENSE.md
    COPYING.GPLv2
    COPYING.LGPLv2.1
  SPDX_LICENSE_IDENTIFIER
    LGPL-2.1-or-later
  SPDX_COPYRIGHT_TEXT
    "Copyright (c) the FFmpeg developers"
  CONFIGURE_COMMAND
    <SOURCE_DIR>/configure
      --prefix=<INSTALL_DIR>
      --disable-avdevice
      --disable-bzlib
      --disable-decoders
      --disable-doc
      --disable-ffplay
      --disable-ffprobe
      --disable-network
      --disable-vaapi
      --disable-vdpau
      --disable-x86asm
      --pkg-config=${superbuild_pkgconf}
      ${ffmpeg_shared_args}
      "--extra-cflags=${ffmpeg_c_flags}"
      "--extra-ldflags=${ffmpeg_ld_flags}"
  BUILD_COMMAND
    $(MAKE)
  INSTALL_COMMAND
    make install
  BUILD_IN_SOURCE 1)

superbuild_apply_patch(ffmpeg swscalex86-yuv2yuvX-revert-conversion-to-assembly
  "revert assembly port of yuv2yuvX function")

# The patch was applied from:
# https://bbs.archlinux.org/viewtopic.php?id=289424
# This fixed the compilation issue on ORNL frontier with
# gcc 13.3.1
superbuild_apply_patch(ffmpeg operand-type-mismatch-for-shr
  "clip constants used with shift instructions within inline assembly")
