from paraview.simple import *

print("Executing data reduction pipeline")

from paraview import catalyst

options = catalyst.Options()
options.GlobalTrigger = "TimeStep"
options.CatalystLiveTrigger = "TimeStep"
options.EnableCatalystLive = 1


# No-op, keep
producer = TrivialProducer(registrationName="grid")

slice = Slice(registrationName='slice', Input=producer)
slice.SliceOffsetValues = [0.0]

slice.SliceType.Set(
    Origin=[1.0, 1.0, 3.0],
    Normal=[0.0, 1.0, 0.0],
)

steering = CreateExtractor("steering", slice, registrationName="steerchannel")


def catalyst_execute(info):
    global slice
    slice.UpdatePipeline()

    print("-----------------------------------")
    print("executing reduction pipeline (cycle={}, time={})".format(info.cycle, info.time))
    print("bounds:", producer.GetDataInformation().GetBounds())
    print("cells:", producer.GetDataInformation().GetNumberOfCells())
    print("points:", producer.GetDataInformation().GetNumberOfPoints())
