from paraview.simple import *

print("Executing data reduction pipeline")

from paraview import catalyst
options = catalyst.Options()

# registrationName must match the channel name used in the
# 'CatalystAdaptor'.
producer = TrivialProducer(registrationName="grid")
mergeBlocks = MergeBlocks(Input=producer, MergePartitionsOnly=1)

# Create a slice of the producer
sliced = Slice(Input=mergeBlocks, SliceType="Plane")
sliced.SliceType.Offset = 0.0
sliced.SliceType.Origin = [60.0, 35.4, 62.35]
sliced.SliceType.Normal = [0.0, 1.0, 0.0]

sliced2 = Slice(Input=mergeBlocks, SliceType="Plane")
sliced2.SliceType.Offset = 0.0
sliced2.SliceType.Origin = [60.0, 35.4, 62.35]
sliced2.SliceType.Normal = [1.0, 0.0, 0.0]

# Create a composite structure out of the slices,
# So the steered extract is processed as multimesh.
grouped = GroupDatasets(Input=[sliced, sliced2])
steering = CreateExtractor("steering", grouped, registrationName="steerchannel")


def catalyst_execute(info):
    global sliced
    sliced.UpdatePipeline()
    print("-----------------------------------")
    print("executing reduction pipeline (cycle={}, time={})".format(info.cycle, info.time))
    print("bounds:", producer.GetDataInformation().GetBounds())
