from paraview.simple import *

print("Executing visualization pipeline on reduced data")

from paraview import catalyst

options = catalyst.Options()
options.GlobalTrigger = "TimeStep"
options.CatalystLiveTrigger = "TimeStep"
options.EnableCatalystLive = 1

producer = TrivialProducer(registrationName="steerchannel")


def catalyst_execute(info):
    global producer
    producer.UpdatePipeline()

    bounds = producer.GetDataInformation().GetBounds()

    # Detect MPI based on bounds
    is_mpi = not (bounds[0] == 0.0 and bounds[1] == 120.0)

    sliceInformation = producer.GetDataInformation()

    if not is_mpi:
        assert (
            sliceInformation.GetNumberOfCells() == 21500
        ), "Sliced data does not have the right number of cells"
        assert (
            sliceInformation.GetNumberOfPoints() == 11088
        ), "Sliced data does not have the right number of points"
    else:
        assert (
            sliceInformation.GetNumberOfCells() == 10750
        ), "Sliced data does not have the right number of cells"
        assert (
            sliceInformation.GetNumberOfPoints() == 5588
        ), "Sliced data does not have the right number of points"
