from paraview.simple import *

print("Executing visualization pipeline on reduced data")

from paraview import catalyst

options = catalyst.Options()
options.GlobalTrigger = "TimeStep"
options.CatalystLiveTrigger = "TimeStep"
options.EnableCatalystLive = 1

producer = TrivialProducer(registrationName="steerchannel")


def catalyst_execute(info):
    global producer
    producer.UpdatePipeline()

    print("-----------------------------------")
    print("executing visualization pipeline (cycle={}, time={})".format(info.cycle, info.time))
    print("bounds:", producer.GetDataInformation().GetBounds())
    print("cells:", producer.GetDataInformation().GetNumberOfCells())
    print("points:", producer.GetDataInformation().GetNumberOfPoints())

    assert (
        producer.GetDataInformation().GetNumberOfCells() == 6
    ), f"Sliced data does not have the right number of cells: {producer.GetDataInformation().GetNumberOfCells()} "
    assert (
        producer.GetDataInformation().GetNumberOfPoints() == 7
    ), f"Sliced data does not have the right number of points: {producer.GetDataInformation().GetNumberOfPoints()} "
