from paraview.simple import *
from paraview.servermanager import vtkProcessModule

print("Executing visualization pipeline on reduced data")

from paraview import catalyst

options = catalyst.Options()
options.GlobalTrigger = "TimeStep"
options.CatalystLiveTrigger = "TimeStep"
options.EnableCatalystLive = 1

producer = TrivialProducer(registrationName="steerchannel")

def catalyst_execute(info):
    global producer
    producer.UpdatePipeline()

    producerInformation = producer.GetDataInformation()

    bounds_x = producerInformation.GetBounds()[0:2]

    if bounds_x == (0.0, 120.0):
        # only 1 rank
        assert (
            producerInformation.GetNumberOfCells() == 304440
        ), f"Reduced data does not have the right number of cells ({producerInformation.GetNumberOfCells()})"
        assert (
            producerInformation.GetNumberOfPoints() == 327360
        ), f"Reduced data does not have the right number of points ({producerInformation.GetNumberOfPoints()})"
    else:
        # multiple ranks
        pm = vtkProcessModule.GetProcessModule()
        controller = pm.GetGlobalController()
        rank = controller.GetLocalProcessId()

        expected_bounds = [
            (0.0, 60.0),
            (60.0, 90.0),
            (90.0, 120.0),
        ]

        expected_number_of_cells = [152220, 76110, 76110]
        expected_number_of_points = [163680, 81840, 81840]

        assert bounds_x == expected_bounds[rank], f"Producer does not have the right bounds ({bounds_x})"

        assert (
            producerInformation.GetNumberOfCells() == expected_number_of_cells[rank]
        ), f"Reduced data does not have the right number of cells ({producerInformation.GetNumberOfCells()})"
        assert (
            producerInformation.GetNumberOfPoints() == expected_number_of_points[rank]
        ), f"Reduced data does not have the right number of points ({producerInformation.GetNumberOfPoints()})"
